package com.biz.crm.member.business.member.local.controller.api;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.CulturalAndTourismRespondentService;
import com.biz.crm.member.business.member.local.service.CulturalAndTourismTopicService;
import com.biz.crm.member.business.member.sdk.vo.CulturalAndTourismInitAPIVo;
import com.biz.crm.member.business.member.sdk.vo.CulturalAndTourismRespondentAPIVo;
import com.biz.crm.member.business.member.sdk.vo.CulturalAndTourismRespondentVo;
import com.biz.crm.member.business.member.sdk.vo.CulturalAndTourismTopicAPIVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author hupan
 * @date 2023/6/25 10:42
 */
@Slf4j
@Api(tags = "小程序文旅答题记录控制层")
@RestController
@RequestMapping(value = {"/v1/api/culturalAndTourismRespondentAPI"})
public class CulturalAndTourismRespondentAPIController {

  @Autowired(required = false)
  private CulturalAndTourismRespondentService culturalAndTourismRespondentService;
  @Autowired(required = false)
  private CulturalAndTourismTopicService culturalAndTourismTopicService;

  /**
   * 首页初始化的数据
   *
   */
  @ApiOperation(value = "首页初始化的数据")
  @GetMapping(value = "/init")
  public Result<CulturalAndTourismInitAPIVo> initData(@RequestParam("phone") String phone){
    try {
      CulturalAndTourismInitAPIVo culturalAndTourismInitAPIVo = culturalAndTourismRespondentService.initData(phone);
      return Result.ok(culturalAndTourismInitAPIVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 文旅答题题目
   *
   * @param
   * @return
   */
  @ApiOperation(value = "文旅答题题目")
  @PostMapping(value = "/questionTopic")
  public Result<CulturalAndTourismTopicAPIVo> questionTopic() {
    try {
      CulturalAndTourismTopicAPIVo current = this.culturalAndTourismTopicService.questionTopic();
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增记录
   *
   * to do
   * 等待积分记录接口
   * @param culturalAndTourismRespondentAPIVo
   * @return
   */
  @ApiOperation(value = "新增记录")
  @PostMapping(value = "")
  public Result<CulturalAndTourismRespondentAPIVo> add(@RequestBody CulturalAndTourismRespondentAPIVo culturalAndTourismRespondentAPIVo) {
    try {
      CulturalAndTourismRespondentAPIVo current = this.culturalAndTourismRespondentService.create(culturalAndTourismRespondentAPIVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
