package com.biz.crm.member.business.member.local.controller.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.entity.MemberInfoReceiptRecord;
import com.biz.crm.member.business.member.local.service.MemberInfoGrowRecordService;
import com.biz.crm.member.business.member.sdk.dto.CardProductDto;
import com.biz.crm.member.business.member.sdk.dto.GrowRecordAPIPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.CardProductVo;
import com.biz.crm.member.business.member.sdk.vo.GrowRecordAPIVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author hupan
 * @date 2023/6/30 13:54
 */
@Slf4j
@Api(tags = "小程序成长值记录控制层")
@RestController
@RequestMapping(value = {"/v1/api/growRecordAPIController"})
public class GrowRecordAPIController {

  @Autowired
  private MemberInfoGrowRecordService memberInfoGrowRecordService;

  @ApiOperation("小程序成长值记录分页条件查询")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<GrowRecordAPIVo>> findByConditions(@PageableDefault(50) Pageable pageable,
      GrowRecordAPIPaginationDto dto) {
    try {
      Page<GrowRecordAPIVo> result = this.memberInfoGrowRecordService.findByConditionsAPI(pageable,dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("详情")
  @GetMapping(value = {"/findDetail"})
  public Result<List<GrowRecordAPIVo>> findDetail(GrowRecordAPIVo vo) {
    try {
      List<GrowRecordAPIVo> result = this.memberInfoGrowRecordService.findDetail(vo);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
