package com.biz.crm.member.business.member.local.controller.api;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.ActivityManageService;
import com.biz.crm.member.business.member.local.service.InfoManageService;
import com.biz.crm.member.business.member.local.service.ViewpagerService;
import com.biz.crm.member.business.member.sdk.enums.UseAreaEnum;
import com.biz.crm.member.business.member.sdk.vo.ActivityManageVo;
import com.biz.crm.member.business.member.sdk.vo.InfoManageVo;
import com.biz.crm.member.business.member.sdk.vo.ViewpagerVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/25 17:21
 * @description 小程序首页
 */
@Slf4j
@Api(tags = "小程序首页")
@RestController
@RequestMapping("/v1/app/index")
public class IndexAPIController {

  @Autowired
  private ViewpagerService viewpagerService;

  @Autowired
  private ActivityManageService activityManageService;

  @Autowired
  private InfoManageService infoManageService;

  @ApiOperation("小程序首页轮播图获取,应用区域,数据字典:mms_use_area")
  @GetMapping("/index/banner")
  public Result<List<ViewpagerVo>> listIndexBanner(@RequestParam("code") String code) {
    try {
      List<ViewpagerVo> result = this.viewpagerService.getEnableOneByUseArea(code);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("小程序首页(活动企划)")
  @GetMapping("/index/activity/plan")
  public Result<ActivityManageVo> getIndexActivityPlan(){
    try {
      ActivityManageVo result = activityManageService.getOneByEnableOrderBySignEndTime();
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("小程序首页(资讯精选)")
  @GetMapping("/index/info")
  public Result<List<InfoManageVo>> getIndexInfoLimitThree(){
    try {
      List<InfoManageVo> result = infoManageService.getAppIndexInfoLimitThree();
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


}
