package com.biz.crm.member.business.member.local.controller.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.entity.Discuss;
import com.biz.crm.member.business.member.local.service.ChoiceNessCategoryService;
import com.biz.crm.member.business.member.local.service.DiscussService;
import com.biz.crm.member.business.member.local.service.InfoCategoryService;
import com.biz.crm.member.business.member.local.service.InfoManageService;
import com.biz.crm.member.business.member.local.service.InfoUpvoteService;
import com.biz.crm.member.business.member.local.service.ViewpagerService;
import com.biz.crm.member.business.member.sdk.dto.DiscussDto;
import com.biz.crm.member.business.member.sdk.enums.InfoApplyModelEnum;
import com.biz.crm.member.business.member.sdk.enums.UseAreaEnum;
import com.biz.crm.member.business.member.sdk.vo.ChoiceNessCategoryVo;
import com.biz.crm.member.business.member.sdk.vo.DiscussVo;
import com.biz.crm.member.business.member.sdk.vo.InfoCategoryVo;
import com.biz.crm.member.business.member.sdk.vo.InfoManageVo;
import com.biz.crm.member.business.member.sdk.vo.ViewpagerVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/27 17:31
 * @description 小程序资讯
 */
@Slf4j
@Api(tags = "小程序资讯")
@RestController
@RequestMapping("/v1/app/info/message")
public class InfoAPIController {

  @Autowired
  private InfoManageService infoManageService;

  @Autowired
  private InfoCategoryService infoCategoryService;

  @Autowired
  private ChoiceNessCategoryService choiceNessCategoryService;

  @Autowired
  private ViewpagerService viewpagerService;

  @Autowired
  private InfoUpvoteService infoUpvoteService;

  @Autowired
  private DiscussService discussService;

  @ApiOperation("小程序端获取资讯分类(根据资讯分类的应用范围,应用范围数据字典:mms_info_category)")
  @GetMapping("/list/info/category")
  public Result<List<InfoCategoryVo>> listEnableInfoCategory(@RequestParam("applyRange") String applyRange){
    try {
      List<InfoCategoryVo> result = this.infoCategoryService.appListEnableInfoCategoryByApplyRange(applyRange);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("小程序获取资讯轮播图")
  @GetMapping("/list/banner")
  public Result<List<ViewpagerVo>> listInfoBanner(){
    try {
      List<ViewpagerVo> result = this.viewpagerService
          .getEnableOneByUseArea(UseAreaEnum.INFO.getCode());
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("小程序端获取有效的精选分类限制3")
  @GetMapping("/list/info/choice/category")
  public Result<List<ChoiceNessCategoryVo>> listEnableChoiceNessCategory(){
    try {
      List<ChoiceNessCategoryVo> result = choiceNessCategoryService
          .appListEnableChoiceNessCategory();
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("小程序端根据精选分类编码获取最新的一个资讯")
  @GetMapping("/get/info/choice/code/last")
  public Result<InfoManageVo> getInfoByChoiceCodeLast(@RequestParam("choiceCategoryCode") String choiceCategoryCode){
    try {
      InfoManageVo result = infoManageService.getInfoByChoiceCodeLast(choiceCategoryCode);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("小程序资讯列表")
  @GetMapping("/page")
  public Result<Page<InfoManageVo>> pageInfoManageApp(@PageableDefault(50) Pageable pageable,
      @RequestParam("infoCategoryCode") String infoCategoryCode) {
    try {
      Page<InfoManageVo> result = infoManageService.pageInfoManageApp(pageable, infoCategoryCode,
          InfoApplyModelEnum.INFO_CHOICE_NESS.getValue());
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("小程序资讯点赞")
  @GetMapping("/info/upvote")
  public Result upvoteInfoByCode(@RequestParam("infoCode") String infoCode){
    try {
      this.infoUpvoteService.addInfoUpvote(infoCode);
      return Result.ok("点赞成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("小程序资讯取消点赞")
  @GetMapping("/info/cancel/upvote")
  public Result cancelUpvoteInfoByCode(@RequestParam("infoCode") String infoCode){
    try {
      this.infoUpvoteService.logicDeleteUpvote(infoCode);
      return Result.ok("取消点赞成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("小程序资讯获取详情")
  @GetMapping("/info/detail")
  public Result<InfoManageVo> getIndexInfoDetailByInfoCode(@RequestParam("infoCode") String infoCode){
    try {
      InfoManageVo result = infoManageService.appGetInfoDetailByCode(infoCode);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("当前用户是否可以评论")
  @GetMapping("/info/discuss/enable")
  public Result<Boolean> getEnableDiscuss(){
    try {
      Boolean result = discussService.enableDiscuss();
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("小程序获取当前资讯的评论信息")
  @GetMapping("/page/info/discuss")
  public Result<Page<DiscussVo>> pageInfoDiscussByInfoCode(@PageableDefault(50) Pageable pageable, @RequestParam("infoCode") String infoCode){
    try {
      Page<DiscussVo> result = discussService.appPageDiscussByInfoCode(pageable, infoCode);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("小程序获取当前资讯自己的最新3条评论")
  @GetMapping("/list/discuss/owner")
  public Result<List<DiscussVo>> listOwnerDiscuss(@RequestParam("infoCode") String infoCode){
    try {
      List<DiscussVo> result = discussService.appListOwnerDiscussLimit(infoCode);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("小程序资讯评论新增")
  @PostMapping("/info/discuss")
  public Result<DiscussVo> createDiscuss(@RequestBody DiscussDto dto){
    try {
      DiscussVo result = discussService.createDiscuss(dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("小程序资讯分享")
  @GetMapping("/info/share")
  public Result<InfoManageVo> appShareInfo(@RequestParam("infoCode") String infoCode){
    try {
      InfoManageVo result = infoManageService.appShareInfoByCode(infoCode);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
