package com.biz.crm.member.business.member.local.controller.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.service.BenefitsManageService;
import com.biz.crm.member.business.member.local.service.LevelManageService;
import com.biz.crm.member.business.member.local.service.MemberInfoBenefitsService;
import com.biz.crm.member.business.member.local.service.MemberInfoService;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletLevelBenefitsVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletLevelManageVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberHoneVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberInfoBenefits;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberInfoBenefitsReqVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zouhs
 * @date 2023/6/29
 */
@Slf4j
@Api(tags = "小程序-会员权益接口")
@RestController
@RequestMapping("/v1/api/memberBenefits")
public class MemberBenefitsController {

  @Autowired
  private UserSearchHelper userSearchHelper;

  @Autowired
  private BenefitsManageService benefitsManageService;

  @Autowired
  private LevelManageService levelManageService;

  @Autowired
  private MemberInfoService memberInfoService;

  @Autowired
  private MemberInfoBenefitsService memberInfoBenefitsService;

  /**
   * 所有会员等级信息(卡片tab)
   *
   * @return
   */
  @ApiOperation(value = "所有会员等级信息(卡片tab)")
  @GetMapping(value = {"/getMemberLevelAll"})
  public Result<List<AppletLevelManageVo>> getMemberLevelAll() {
    try {
      String memberCode = userSearchHelper.getMemberLogin().getMemberCode();
      List<AppletLevelManageVo> appletLevelManageVos = this.levelManageService.getMemberLevelAll(memberCode);
      return Result.ok(appletLevelManageVos);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 查看权益(会员当前等级信息)
   *
   * @return
   */
  @ApiOperation(value = "会员我的首页 - 查看权益(会员权益)")
  @GetMapping(value = {"/getMemberLevelInfo"})
  public Result<AppletMemberHoneVo> getMemberLevelInfo() {
    try {
      String memberCode = userSearchHelper.getMemberLogin().getMemberCode();
      AppletMemberHoneVo appletMemberHoneVo = this.memberInfoService.getMemberLevelInfo(memberCode);
      return Result.ok(appletMemberHoneVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 会员权益列表信息
   *
   * @return
   */
  @ApiOperation(value = "会员权益列表信息")
  @GetMapping(value = {"/getMemberBenefitsList"})
  public Result<List<AppletLevelBenefitsVo>> getMemberBenefitsList(@RequestParam("levelCode") String levelCode) {
    try {
      String memberCode = userSearchHelper.getMemberLogin().getMemberCode();
      List<AppletLevelBenefitsVo> appletLevelBenefitsVos = this.levelManageService.getMemberBenefitsList(levelCode,memberCode);
      return Result.ok(appletLevelBenefitsVos);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 会员权益列表信息
   *
   * @return
   */
  @ApiOperation(value = "会员权益兑换")
  @GetMapping(value = {"/getMemberInfoBenefitsList"})
  public Result<Page<AppletMemberInfoBenefits>> getMemberInfoBenefitsList(@PageableDefault(50) Pageable pageable,
      AppletMemberInfoBenefitsReqVo appletMemberInfoBenefitsReqVo) {
    try {
      String memberCode = userSearchHelper.getMemberLogin().getMemberCode();
      appletMemberInfoBenefitsReqVo.setMemberCode(memberCode);
      Page<AppletMemberInfoBenefits> appletLevelBenefitsVos = this.memberInfoBenefitsService.getMemberInfoBenefitsList(pageable,appletMemberInfoBenefitsReqVo);
      return Result.ok(appletLevelBenefitsVos);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 权益兑换详情
   *
   * @return
   */
  @ApiOperation(value = "权益兑换详情")
  @GetMapping(value = {"/getMemberInfoBenefitsDetailById"})
  public Result<AppletMemberInfoBenefits> getMemberInfoBenefitsDetailById(@RequestParam("id") String id) {
    try {
      String memberCode = userSearchHelper.getMemberLogin().getMemberCode();
      AppletMemberInfoBenefits appletMemberInfoBenefits = this.memberInfoBenefitsService.getMemberInfoBenefitsDetailById(memberCode,id);
      return Result.ok(appletMemberInfoBenefits);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 权益提交兑换
   *
   * @return
   */
  @ApiOperation(value = "权益提交兑换")
  @PostMapping(value = {"/getMemberInfoBenefitsSubmit"})
  public Result<AppletMemberInfoBenefits> getMemberInfoBenefitsSubmit(@RequestBody AppletMemberInfoBenefits appletMemberInfoBenefits) {
    try {
      String memberCode = userSearchHelper.getMemberLogin().getMemberCode();
      appletMemberInfoBenefits.setMemberCode(memberCode);
      AppletMemberInfoBenefits result = this.memberInfoBenefitsService.getMemberInfoBenefitsSubmit(appletMemberInfoBenefits);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
