package com.biz.crm.member.business.member.local.controller.api;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.service.MemberInfoService;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberHoneVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberInfoReqVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberInfoVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 会员相关接口
 * @author zouhs
 * @date 2023/6/29
 */
@Slf4j
@Api(tags = "小程序-会员相关接口")
@RestController
@RequestMapping("/v1/api/memberInfo")
public class MemberInfoHomeController {

  @Autowired
  private MemberInfoService memberInfoService;

  @Autowired
  private UserSearchHelper userSearchHelper;

  /**
   * 会员基础资料
   *
   * @return
   */
  @ApiOperation(value = "会员基础资料")
  @GetMapping(value = {"/getMemberInfo"})
  public Result<AppletMemberInfoVo> getMemberInfo() {
    try {
      String memberCode = userSearchHelper.getMemberLogin().getMemberCode();
      AppletMemberInfoVo appletMemberInfoVo = this.memberInfoService.getMemberInfo(memberCode);
      return Result.ok(appletMemberInfoVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 会员修改生日
   *
   * @return
   */
  @ApiOperation(value = "会员修改生日")
  @PostMapping(value = {"/updMemberBirthday"})
  public Result updMemberBirthday(AppletMemberInfoReqVo appletMemberInfoReqVo) {
    try {
      String memberCode = userSearchHelper.getMemberLogin().getMemberCode();
      appletMemberInfoReqVo.setMemberCode(memberCode);
      this.memberInfoService.updMemberBirthday(appletMemberInfoReqVo);
      return Result.ok("操作成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 会员我的首页信息
   *
   * @return
   */
  @ApiOperation(value = "会员我的首页信息")
  @GetMapping(value = {"/getMemberHome"})
  public Result<AppletMemberHoneVo> getMemberHome() {
    try {
      String memberCode = userSearchHelper.getMemberLogin().getMemberCode();
      AppletMemberHoneVo appletMemberHoneVo = this.memberInfoService.getMemberHome(memberCode);
      return Result.ok(appletMemberHoneVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
