package com.biz.crm.member.business.member.local.controller.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.service.MemberInfoIntegralRecordService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoIntegralRecordPaginationAPIDto;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoIntegralRecordAPIVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 小程序会员积分变动记录
 *
 * @author hupan
 * @date 2023/6/27 10:40
 */
@Slf4j
@Api(tags = "小程序会员积分变动记录")
@RestController
@RequestMapping(value = {"/v1/api/memberInfoIntegralRecordAPI"})
public class MemberInfoIntegralRecordAPIController {

  @Autowired(required = false)
  private MemberInfoIntegralRecordService memberInfoIntegralRecordService;
  @Autowired
  private UserSearchHelper userSearchHelper;

  /**
   * 小程序会员积分变动记录分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "小程序会员积分变动记录分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<MemberInfoIntegralRecordAPIVo>> findByConditions(@PageableDefault(50) Pageable pageable,
      MemberInfoIntegralRecordPaginationAPIDto paginationDto) {
    try {
      Page<MemberInfoIntegralRecordAPIVo> result = this.memberInfoIntegralRecordService
          .findByConditionsAPI(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 小程序积分记录-当前积分和即将过期积分
   */
  @ApiOperation(value = "小程序积分记录-当前积分和即将过期积分")
  @GetMapping(value = {"/initData"})
  public Result<MemberInfoIntegralRecordAPIVo> initData(){
    try {
      String memberCode = userSearchHelper.getMemberLogin().getMemberCode();
      MemberInfoIntegralRecordAPIVo result = this.memberInfoIntegralRecordService.initData(memberCode);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
