package com.biz.crm.member.business.member.local.controller.api;

import cn.hutool.core.date.DateUtil;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.MemberInfoSignService;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoSignVo;
import com.biz.crm.member.business.member.sdk.vo.SignInfoVo;
import com.biz.crm.member.business.member.sdk.vo.SignResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/29 10:52
 * @description
 */
@Slf4j
@Api(tags = "小程序签到")
@RestController
@RequestMapping("/v1/app/member/sign")
public class MemberSignAPIController {

  @Autowired
  private MemberInfoSignService memberInfoSignService;

  @ApiOperation("小程序获取签到记录（仅仅只是签到记录）,参数时间的传递格式必须为: yyyy-MM")
  @GetMapping("/records")
  public Result<List<MemberInfoSignVo>> listMemberInfoSign(@RequestParam(value = "dateTime",required = false) String dateTime){
    try {
      if(StringUtils.isBlank(dateTime)){
        dateTime = DateUtil.format(new Date(),"yyyy-MM");
      }
      List<MemberInfoSignVo> result = memberInfoSignService.listCurrentUserMemberInfoSign(dateTime);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("小程序获取签到记录信息页面其他信息,参数时间的传递格式必须为: yyyy-MM")
  @GetMapping("/detail")
  public Result<SignInfoVo> getSignDetail(@RequestParam(value = "dateTime",required = false) String dateTime){
    try {
      if(StringUtils.isBlank(dateTime)){
        dateTime = DateUtil.format(new Date(),"yyyy-MM");
      }
      SignInfoVo result = memberInfoSignService.getSignDetail(dateTime);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("小程序签到")
  @GetMapping("/sign/today")
  public Result<SignResultVo> sign(){
    try {
      SignResultVo result = this.memberInfoSignService.appSign();
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


}
