package com.biz.crm.member.business.member.local.controller.api;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.NearestAndNearbyStoresAPIService;
import com.biz.crm.member.business.member.sdk.vo.NearestAndNearbyStoresAPIVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * TODO
 *
 * @author hupan
 * @date 2023/6/26 15:46
 */
@Slf4j
@Api(tags = "小程序首页附件门店和最近门店,需要从主数据拿到数据,目前的数据是假数据")
@RestController
@RequestMapping("/v1/api/nearestAndAccessoryStores")
public class NearestAndNearbyStoresAPIController {

  @Autowired(required = false)
  private NearestAndNearbyStoresAPIService nearestAndNearbyStoresAPIService;
//  @Autowired
//  private TerminalMiniProgram

  @ApiOperation("小程序首页最近门店只需要经纬度的信息,封装到nearestAndNearbyStoresAPIVo里面: 返回值需要从主数据拿")
  @PostMapping("/nearest")
  public Result<NearestAndNearbyStoresAPIVo> nearestStores(@RequestBody NearestAndNearbyStoresAPIVo nearestAndNearbyStoresAPIVo) {
    try {
      NearestAndNearbyStoresAPIVo nearbyStoresAPIVo = nearestAndNearbyStoresAPIService.findNearestStores(nearestAndNearbyStoresAPIVo);
      return Result.ok(nearbyStoresAPIVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("小程序首页附近门店: 返回值需要从主数据拿")
  @GetMapping("/accessory")
  public Result<List<NearestAndNearbyStoresAPIVo>> accessoryStores(NearestAndNearbyStoresAPIVo nearestAndNearbyStoresAPIVo) {
    try {
      List<NearestAndNearbyStoresAPIVo> result = nearestAndNearbyStoresAPIService.findByConditional(nearestAndNearbyStoresAPIVo);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
