package com.biz.crm.member.business.member.local.controller.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.member.business.member.local.service.DummyOrderService;
import com.biz.crm.member.business.member.local.service.RealOrderService;
import com.biz.crm.member.business.member.local.service.VerificationUserService;
import com.biz.crm.member.business.member.sdk.constants.VerificationOrderConstants;
import com.biz.crm.member.business.member.sdk.dto.AppOrderPaginationDto;
import com.biz.crm.member.business.member.sdk.dto.DispatchSalesmanDto;
import com.biz.crm.member.business.member.sdk.dto.RealOrderDto;
import com.biz.crm.member.business.member.sdk.dto.VerificationRealOrderDto;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoArchivesVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoVo;
import com.biz.crm.member.business.member.sdk.vo.RealOrderVo;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.MemberInfoService;
import com.biz.crm.member.business.member.sdk.vo.PersonalCenterAPIVo;
import com.biz.crm.member.business.member.sdk.vo.VerificationUserVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author hupan
 * @date 2023/6/29 9:21
 */
@Slf4j
@RestController
@Api(tags = "小程序个人中心")
@RequestMapping("/v1/app/personal/center")
public class PersonalCenterAPIController {
  @Autowired
  private DummyOrderService dummyOrderService;

  @Autowired
  private RealOrderService realOrderService;

  @Autowired(required = false)
  private MemberInfoService memberInfoService;

  @Autowired
  private VerificationUserService verificationUserService;

  @Autowired
  private RedissonClient redissonClient;

  @ApiOperation("我的名片")
  @GetMapping("/queryMyCard")
  public Result<PersonalCenterAPIVo> queryMyCard(){
    try {
      PersonalCenterAPIVo personalCenterAPIVo = memberInfoService.queryMemberAssociationInfoCard();
      return Result.ok(personalCenterAPIVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("购酒服务")
  @GetMapping("/purchaseAlcohol")
  public Result<PersonalCenterAPIVo> purchaseAlcohol(){
    try {
      PersonalCenterAPIVo personalCenterAPIVo = memberInfoService.queryMemberAssociationInfo();
      return Result.ok(personalCenterAPIVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * @Author 吴平
   */
  @ApiOperation(value = "小程序虚拟订单",notes = "当订单状态orderStatus为待核销||即将过期时展示'出示核销码按钮'")
  @GetMapping("/page/dummy/order")
  public Result<Page<DummyOrderVo>> pageUserDummyOrder(@PageableDefault(50) Pageable pageable,
      AppOrderPaginationDto dto) {
    try {
      Page<DummyOrderVo> result = dummyOrderService.appPageDummyOrder(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * @Author 吴平
   */
  @ApiOperation(value = "小程序实物订单",notes = "当订单状态orderStatus为配送中时展示‘出示核销码按钮’")
  @GetMapping("/page/real/order")
  public Result<Page<RealOrderVo>> pageUserRealOrder(@PageableDefault(50) Pageable pageable,
      AppOrderPaginationDto dto) {
    try {
      Page<RealOrderVo> result = realOrderService.appPageRealOrder(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("虚拟核销")
  @GetMapping("/dummy/order/write")
  public Result writeDummyOrder(@RequestParam("dummyOrderId") String dummyOrderId){
    Validate.notBlank(dummyOrderId, "订单Id不能为空");
    String lockKey = String
        .format(VerificationOrderConstants.VERIFICATION_DUMMY_ORDER_LOCK_KEY, dummyOrderId);
    RLock rLock = this.redissonClient.getLock(lockKey);
    boolean lockFlag = rLock.tryLock();
    Validate.isTrue(lockFlag, "当前订单正在核销中,请稍后重试");
    try {
      this.dummyOrderService.writeDummyOrderById(dummyOrderId);
      return Result.ok("虚拟订单核销成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    } finally {
      rLock.unlock();
    }
  }

  @ApiOperation("获取虚拟订单详情")
  @GetMapping("/dummy/order/detail")
  public Result<DummyOrderVo> dummyOrderDetailById(@RequestParam("dummyOrderId") String dummyOrderId) {
      try {
        DummyOrderVo result = this.dummyOrderService.findDetailById(dummyOrderId);
        return Result.ok(result);
      } catch (RuntimeException e) {
        log.error(e.getMessage(), e);
        return Result.error(e.getMessage());
      }
  }

  @ApiOperation("业务员获取自己的配送订单&配送订单复用")
  @GetMapping("/page/delivery/order")
  public Result<Page<RealOrderVo>> pageDeliveryOrder(@PageableDefault(50) Pageable pageable,
      @RequestParam("orderStatus") String orderStatus){
    try {
      Page<RealOrderVo> result = this.realOrderService.appPageDeliveryOrder(pageable, orderStatus);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("获取分发订单")
  @GetMapping("/dispatch/order")
  public Result<Page<RealOrderVo>> pageDispatchOrder(@PageableDefault(50) Pageable pageable,
      @RequestParam("orderStatus") String orderStatus){
    try {
      Page<RealOrderVo> result = this.realOrderService.appPageDispatchOrder(pageable, orderStatus);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("获取分发业务员名单")
  @GetMapping("/list/dispatch/salesman")
  public Result<List<VerificationUserVo>> listDispatchSalesman(){
    try {
      List<VerificationUserVo> result = this.verificationUserService.listDispatchSalesman();
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("为订单分发业务员")
  @PostMapping("/dispatch/salesman/for/order")
  public Result dispatchSalesmanForOrder(@RequestBody DispatchSalesmanDto dto){
    try {
      this.realOrderService.appDispatchSalesmanForOrder(dto);
      return Result.ok("分发成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("实物核销")
  @PostMapping("/real/order/write")
  public Result writeRealOrder(@RequestBody VerificationRealOrderDto dto){
    this.validateRealOrderVerification(dto);
    String realOrderId = dto.getVerificationOrderId();
    String lockKey = String
        .format(VerificationOrderConstants.VERIFICATION_REAL_ORDER_LOCK_KEY, realOrderId);
    RLock rLock = this.redissonClient.getLock(lockKey);
    boolean lockFlag = rLock.tryLock();
    Validate.isTrue(lockFlag, "当前订单正在核销中,请稍后重试");
    try {
      this.realOrderService.appWriteOrderById(dto);
      return Result.ok("核销成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    } finally {
      rLock.unlock();
    }
  }

  @ApiOperation("获取经销商")
  @GetMapping("/list/agent")
  public Result<List<CustomerVo>> listCustomer(){
    try {
      List<CustomerVo> result = this.realOrderService.appListAgentCustomer();
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("获取实物订单详情")
  @GetMapping("/real/order/id")
  public Result<RealOrderVo> getRealOrderById(@RequestParam("realOrderId") String realOrderId){
    try {
      RealOrderVo result = this.realOrderService.findDetailById(realOrderId);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("去配送")
  @GetMapping("/real/order/delivery")
  public Result deliveryOrder(@RequestParam("orderId") String orderId){
    try {
      this.realOrderService.appDeliveryOrderById(orderId);
      return Result.ok("配送中");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  private void validateRealOrderVerification(VerificationRealOrderDto dto) {
    Validate.notNull(dto, "订单信息不能为空");
    String realOrderId = dto.getVerificationOrderId();
    Validate.notBlank(realOrderId, "核销人员提供的订单Id不能为空");
    String customerOrderId = dto.getCustomerOrderId();
    Validate.notBlank(customerOrderId, "客户提供的订单Id不能为空");
    Validate.isTrue(realOrderId.equals(customerOrderId), "客户提供的订单信息不匹配,核销失败");
  }
}
