package com.biz.crm.member.business.member.local.controller.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.QuestionnaireService;
import com.biz.crm.member.business.member.sdk.dto.QuestionnaireDto;
import com.biz.crm.member.business.member.sdk.dto.QuestionnaireSubmitDto;
import com.biz.crm.member.business.member.sdk.vo.QuestionAnswerVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionnaireDetailVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionnaireVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/26 9:39
 * @description 小程序调查问卷
 */
@Slf4j
@Api(tags = "小程序调查问卷")
@RestController
@RequestMapping("/v1/app/questionnaire")
public class QuestionnaireAPIController {

  @Autowired
  private QuestionnaireService questionnaireService;

  @ApiOperation("小程序调查问卷列表,数据字典：mms_app_questionnaire; rangeStatus属性的值，从该字典中获取")
  @GetMapping("/page/questionnaire")
  public Result<Page<QuestionnaireVo>> pageQuestionnaireInfoWithStatus(@PageableDefault(50)
      Pageable pageable,@RequestParam("rangeStatus") String rangeStatus) {
    try {
      Page<QuestionnaireVo> result = this.questionnaireService
          .pageQuestionnaireWithStatus(pageable, rangeStatus);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 由于将小程序中调查问卷列表的三个接口综合为了一个接口，故将下面两个接口暂时注释
   */
/*  @ApiOperation("小程序调查问卷列表(可参与)")
  @GetMapping("/page/questionnaire/allow/join")
  public Result<Page<QuestionnaireVo>> pageQuestionnaireInfoByAllow(@PageableDefault(50)
      Pageable pageable) {
    try {
      Page<QuestionnaireVo> result = this.questionnaireService.pageQuestionnaireAllowJoin(pageable);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("小程序调查问卷列表(已提交)")
  @GetMapping("/page/questionnaire/submitted")
  public Result<Page<QuestionnaireVo>> pageQuestionnaireInfoBySubmitted(@PageableDefault(50)
      Pageable pageable) {
    try {
      Page<QuestionnaireVo> result = this.questionnaireService
          .pageQuestionnaireBySubmitted(pageable);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }*/

  @ApiOperation("小程序调查问卷详情")
  @GetMapping("/questionnaire/detail")
  public Result<QuestionnaireDetailVo> getQuestionnaireDetail(
      @RequestParam("questionnaireCode") String questionnaireCode) {
    try {
      QuestionnaireDetailVo result = this.questionnaireService
          .getQuestionnaireDetailByCode(questionnaireCode);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("小程序查看调查问卷答卷")
  @GetMapping("/questionnaire/detail/submit")
  public Result<List<QuestionAnswerVo>> getQuestionnaireDetailBySubmit(
      @RequestParam("questionnaireCode") String questionnaireCode) {
    try {
      List<QuestionAnswerVo> result = this.questionnaireService
          .getQuestionnaireDetailBySubmit(questionnaireCode);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("小程序提交问卷")
  @PostMapping("/submit/questionnaire")
  public Result<QuestionnaireVo> submitQuestionnaire(@RequestBody List<QuestionnaireSubmitDto> dtoList) {
    try {
      QuestionnaireVo result = this.questionnaireService.submitQuestionnaire(dtoList);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
