package com.biz.crm.member.business.member.local.controller.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.RewardActivityLotteryService;
import com.biz.crm.member.business.member.sdk.dto.LotteryDto;
import com.biz.crm.member.business.member.sdk.dto.RafflePrizeRecordDto;
import com.biz.crm.member.business.member.sdk.vo.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import javax.security.auth.message.AuthException;
import javax.servlet.http.HttpServletRequest;
import java.security.NoSuchAlgorithmException;

/**
 * 大转盘活动抽奖
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/28 15:04
 **/
@Slf4j
@Api(tags = "小程序大转盘活动抽奖")
@RestController
@RequestMapping("/v1/api/activity/lottery")
public class RewardActivityLotteryController {

    @Autowired
    private RewardActivityLotteryService rewardActivityLotteryService;

    @ApiOperation("中奖记录(当前登录人)")
    @GetMapping("/findByConditions")
    public Result<Page<RafflePrizeRecordVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                             RafflePrizeRecordDto rafflePrizeRecordDto) {
        try {
            Page<RafflePrizeRecordVo> result = this.rewardActivityLotteryService.findByConditions(pageable,rafflePrizeRecordDto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("活动规则")
    @GetMapping("/getRuleDes")
    public Result<String> getRuleDes(@RequestParam("activityCode") String activityCode) {

        try {
            String ruleDes = this.rewardActivityLotteryService.getRuleDes(activityCode);
            Result result = Result.ok("");
            result.setResult(ruleDes);
            return result;
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }

    }


    @ApiOperation("用户剩余抽奖次数/每次消耗积分/大转盘配置")
    @GetMapping("/rewardInfo")
    public Result<LotteryVo> rewardInfo(@RequestParam("activityCode") String activityCode) {

        try {
            LotteryVo lotteryVo = this.rewardActivityLotteryService.rewardInfo(activityCode);
            return Result.ok(lotteryVo);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }

    }


    /**
     * 抽奖
     */
    @ApiOperation(value = "抽奖")
    @PostMapping(value = "lottery")
    public Result<RafflePrizeDetailsVo> lottery(@RequestBody LotteryDto lotteryDto) {
        try {
            RafflePrizeDetailsVo current = rewardActivityLotteryService.lottery(lotteryDto);
            return Result.ok(current);
        }  catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }





}
