package com.biz.crm.member.business.member.local.controller.api;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.RewardInfoService;
import com.biz.crm.member.business.member.sdk.dto.RewardInfoDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 大转盘奖励信息
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/30 14:33
 **/
@Slf4j
@Api(tags = "大转盘奖励信息")
@RestController
@RequestMapping("/v1/api/activity/reward")
public class RewardInfoController {


    @Autowired
    private RewardInfoService rewardInfoService;

    @ApiOperation("领取奖励")
    @PostMapping("/claim")
    public Result<?> claim(@RequestBody RewardInfoDto rewardInfoDto) {

        try {
             this.rewardInfoService.claim(rewardInfoDto);
             return Result.ok("领取成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }

    }



}
