package com.biz.crm.member.business.member.local.controller.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.entity.MessageNotify;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.service.AddressManageService;
import com.biz.crm.member.business.member.local.service.AppletPopupNotifyService;
import com.biz.crm.member.business.member.local.service.MemberInfoIntegralRecordService;
import com.biz.crm.member.business.member.local.service.MemberInfoService;
import com.biz.crm.member.business.member.local.service.MessageNotifyService;
import com.biz.crm.member.business.member.local.service.SystemSettingsDetailService;
import com.biz.crm.member.business.member.sdk.dto.AddressManagePaginationDto;
import com.biz.crm.member.business.member.sdk.dto.MessageNotifyPaginationDto;
import com.biz.crm.member.business.member.sdk.enums.SystemSettingsTypeEnum;
import com.biz.crm.member.business.member.sdk.enums.TriggerConditionEnum;
import com.biz.crm.member.business.member.sdk.enums.TriggerTypeEnum;
import com.biz.crm.member.business.member.sdk.vo.AddressManageVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoVo;
import com.biz.crm.member.business.member.sdk.vo.MessageNotifyVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberBaseInfoVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletPopupNotifyVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletSystemSettingsServiceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.text.ParseException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author hupan
 * @date 2023/6/30 9:23
 */
@Slf4j
@Api(tags = "小程序个人中心-系统设置控制层")
@RestController
@RequestMapping(value = {"/v1/api/systemSettingAPI"})
public class SystemSettingAPIController {

  @Autowired
  private MemberInfoService memberInfoService;
  @Autowired
  private UserSearchHelper userSearchHelper;
  @Autowired
  private AddressManageService addressManageService;
  @Autowired
  private SystemSettingsDetailService systemSettingsDetailService;
  @Autowired
  private MemberInfoIntegralRecordService memberInfoIntegralRecordService;
  @Autowired
  private AppletPopupNotifyService appletPopupNotifyService;
  @Autowired
  private MessageNotifyService messageNotifyService;

  /**
   * 个人信息查看
   */
  @ApiOperation("个人信息查看")
  @GetMapping("/personalInfo")
  public Result<AppletMemberBaseInfoVo> findPersonalInfo() {
    try {
      AppletMemberBaseInfoVo result = this.memberInfoService
          .findBaseInfoByMemberCode(userSearchHelper.getMemberLogin().getMemberCode());
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 个人信息修改
   */
  @ApiOperation("个人信息修改,一次修改一项,只填一项的值")
  @GetMapping("/updatePersonalInfo")
  public Result<AppletMemberBaseInfoVo> updatePersonalInfo(
      AppletMemberBaseInfoVo appletMemberBaseInfoVo) {
    try {
      AppletMemberBaseInfoVo result = this.memberInfoService.updateBase(appletMemberBaseInfoVo);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查看地址信息分页
   *
   * @param pageable
   * @param pageDto
   * @return
   */
  @ApiOperation(value = "查看地址信息分页")
  @GetMapping(value = {"/addressInfo"})
  public Result<Page<AddressManageVo>> addressInfo(@PageableDefault(50) Pageable pageable,
      AddressManagePaginationDto pageDto) {
    try {
      Page<AddressManageVo> result = this.addressManageService.findByConditions(pageable, pageDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建地址信息
   *
   * @param addressManageVo
   * @return
   */
  @ApiOperation(value = "创建地址信息")
  @PostMapping(value = "/createAddress")
  public Result<AddressManageVo> createAddress(@RequestBody AddressManageVo addressManageVo) {
    try {
      AddressManageVo current = this.addressManageService.create(addressManageVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新地址信息
   *
   * @param addressManageVo
   * @return
   */
  @ApiOperation(value = "更新地址信息")
  @PostMapping(value = "/updateAddress")
  public Result<AddressManageVo> updateAddress(@RequestBody AddressManageVo addressManageVo) {
    try {
      AddressManageVo current = this.addressManageService.update(addressManageVo);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据id查询详情
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "根据id查询地址详情")
  @GetMapping(value = "/findDetailById")
  public Result<AddressManageVo> findDetailById(@RequestParam("id") String id) {
    try {
      AddressManageVo addressManageVo = this.addressManageService.findDetailById(id);
      return Result.ok(addressManageVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据id,设置为默认地址
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "设置为默认地址")
  @GetMapping(value = "/setDefault")
  public Result setDefault(@RequestParam("id") String id) {
    try {
      this.addressManageService.setDefault(id);
      return Result.ok("设置为默认地址成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除地址
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "删除地址")
  @GetMapping(value = "/deleteAddress")
  public Result deleteAddress(@RequestParam("id") String id) {
    try {
      this.addressManageService.updateDelFlagById(id);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 客服配置
   *
   * @return
   */
  @ApiOperation(value = "客服配置")
  @GetMapping(value = "/customerConf")
  public Result<AppletSystemSettingsServiceVo> customerConf() {
    try {
      AppletSystemSettingsServiceVo current = systemSettingsDetailService.findByType(
          SystemSettingsTypeEnum.CUSTOMER_SERVICE_CONFIG.getValue());
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 获取弹窗
   *
   * @return
   */
  @ApiOperation(value = "获取弹窗")
  @GetMapping(value = "/selectOne")
  public Result<AppletPopupNotifyVo> selectOne() {
    try {
      AppletPopupNotifyVo appletPopupNotifyVo = appletPopupNotifyService.selectOne();
      return Result.ok(appletPopupNotifyVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查看消息通知分页
   *
   * @param pageable
   * @param pageDto
   * @return
   */
  @ApiOperation(value = "查看消息通知分页")
  @GetMapping(value = {"/findMessageByCondition"})
  public Result<Page<MessageNotifyVo>> findMessageByCondition(@PageableDefault(50) Pageable pageable,
      MessageNotifyPaginationDto pageDto) {
    try {
      Page<MessageNotifyVo> result = this.messageNotifyService.findByConditions(pageable, pageDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 增加消息通知
   *
   * @param messageNotifyVo
   * @return
   */
  @ApiOperation(value = "增加消息通知")
  @PostMapping(value = {"/createMsgNotify"})
  public Result createMsgNotify(@RequestBody MessageNotifyVo messageNotifyVo) {
    try {
      this.messageNotifyService.create(messageNotifyVo);
      return Result.ok("添加成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 定时任务测试
   *
   * @return
   */
  @ApiOperation(value = "测试")
  @GetMapping(value = "/test")
  public Result test() {
    try {
      AppletPopupNotifyVo appletPopupNotifyVo = new AppletPopupNotifyVo();
      appletPopupNotifyVo.setMemberCode(userSearchHelper.getMemberLogin().getMemberCode());
      appletPopupNotifyVo.setTriggerType(TriggerTypeEnum.LEVEL.getCode());
      appletPopupNotifyVo.setTriggerConditions(TriggerConditionEnum.LEVEL_EXPIRED.getCode());
      appletPopupNotifyService.addOne(appletPopupNotifyVo);
      return Result.ok("current");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
