package com.biz.crm.member.business.member.local.controller.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.entity.SystemSettingsDetail;
import com.biz.crm.member.business.member.local.service.CardProductService;
import com.biz.crm.member.business.member.local.service.SystemSettingsDetailService;
import com.biz.crm.member.business.member.local.service.TouristAPIService;
import com.biz.crm.member.business.member.sdk.dto.CardProductDto;
import com.biz.crm.member.business.member.sdk.enums.SystemSettingsDetailEnum;
import com.biz.crm.member.business.member.sdk.vo.CardProductVo;
import com.biz.crm.member.business.member.sdk.vo.TouristAPIVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 小程序游客
 *
 * to do 小程序二维码邀请后面做
 * @author hupan
 * @date 2023/6/28 10:42
 */
@Slf4j
@Api(tags = "小程序游客")
@RestController
@RequestMapping("/v1/api/touristAPI")
public class TouristAPIController {

  @Autowired(required = false)
  private CardProductService cardProductService;
  @Autowired
  private TouristAPIService touristAPIService;
  @Autowired
  private SystemSettingsDetailService systemSettingsDetailService;

  @ApiOperation("小程序游客产品介绍分页")
  @GetMapping(value = {"/findAll"})
  public Result<Page<CardProductVo>> findByConditions(@PageableDefault(50) Pageable pageable) {
    try {
      CardProductDto cardProductDto = new CardProductDto();
      Page<CardProductVo> result = this.cardProductService.findByConditions(pageable,cardProductDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("公司介绍")
  @GetMapping(value = {"/companyDesc"})
  public Result<TouristAPIVo> companyDesc(){
    try {
      SystemSettingsDetail valueByKey = systemSettingsDetailService
          .findValueByKey(SystemSettingsDetailEnum.CARD_PAGE_COMPANY_PROFILE.getValue());
      TouristAPIVo touristAPIVo = new TouristAPIVo();
      touristAPIVo.setCompanyDesc(valueByKey.getTypeValueText());
      return Result.ok(touristAPIVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("卡片信息")
  @GetMapping(value = {"/cardInfo"})
  public Result<TouristAPIVo> cardInfo(){
    try {
      TouristAPIVo touristAPIVo = touristAPIService.cardInfo();
      return Result.ok(touristAPIVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
