package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 活动-报名配置
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/16 10:58
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActivityApplyConfig", description = "活动-报名配置")
@Entity
@TableName("mms_activity_apply_config")
@Table(
        name = "mms_activity_apply_config")
@org.hibernate.annotations.Table(appliesTo = "mms_activity_apply_config", comment = "活动-报名配置")
public class ActivityApplyConfig extends TenantFlagOpEntity {

    @ApiModelProperty("活动编码")
    @TableField(value = "activity_code")
    @Column(name = "activity_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动编码'")
    private String activityCode;

    @ApiModelProperty("组件字段")
    @TableField(value = "field")
    @Column(name = "field",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '组件字段'")
    private String field;

    @ApiModelProperty("组件类型")
    @TableField(value = "type")
    @Column(name = "type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '组件类型'")
    private String type;

    @ApiModelProperty("提示语")
    @TableField(value = "placeholder")
    @Column(name = "placeholder", length = 64, columnDefinition = "VARCHAR(64) COMMENT '提示语'")
    private String placeholder;

    @ApiModelProperty("是否必填")
    @TableField(value = "required")
    @Column(name = "required", length = 1, columnDefinition = "tinyint(1) COMMENT '是否必填'")
    private Boolean required;

    @ApiModelProperty("默认值")
    @TableField(value = "default_value")
    @Column(name = "default_value", length = 100, columnDefinition = "VARCHAR(100) COMMENT '默认值'")
    private String defaultValue;

    @ApiModelProperty("排序（按数字顺序排列）")
    @TableField(value = "sort_index")
    @Column(name = "sort_index",length = 11,  columnDefinition = "int(11) COMMENT '序号'")
    private Integer sortIndex;

    @ApiModelProperty("标题")
    @TableField(value = "title")
    @Column(name = "title", length = 64, columnDefinition = "VARCHAR(64) COMMENT '标题'")
    private String title;

    @ApiModelProperty("多选/单选的json值")
    @TableField(value = "config_json_value")
    @Column(name = "config_json_value",length = 500, columnDefinition = "VARCHAR(500) COMMENT '多选,单选的json值'")
    private String configJsonValue;

    @ApiModelProperty("审批状态")
    @TableField(value = "approval_status")
    @Column(name = "approval_status", length = 64, columnDefinition = "VARCHAR(64) COMMENT '审批状态'")
    private String approvalStatus;

}
