package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * 活动报名记录
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/19 18:51
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActivityApplyRecord", description = "活动-活动报名记录")
@Entity
@TableName("mms_activity_apply_record")
@Table(
        name = "mms_activity_apply_record")
@org.hibernate.annotations.Table(appliesTo = "mms_activity_apply_record", comment = "活动-活动报名记录")
public class ActivityApplyRecord extends TenantFlagOpEntity {

    @ApiModelProperty("活动编码")
    @Column(name = "activity_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动编码'")
    private String activityCode;

    @ApiModelProperty("报名记录编码")
    @Column(name = "record_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '报名记录编码'")
    private String recordCode;

    @ApiModelProperty("我报名时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "apply_date", nullable = false, length = 64, columnDefinition = "datetime COMMENT '我报名时间'")
    private Date applyDate;


    @ApiModelProperty("报名者姓名")
    @Column(name = "apply_user_Name",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '报名者姓名'")
    private String applyUserName;

    @ApiModelProperty("报名者手机号")
    @Column(name = "apply_user_phone", length = 64, columnDefinition = "VARCHAR(64) COMMENT '报名者手机号'")
    private String applyUserPhone;


    @ApiModelProperty("报名者关联组织")
    @Column(name = "apply_user_org", length = 64, columnDefinition = "VARCHAR(64) COMMENT '报名者关联组织'")
    private String applyUserOrg;

    @ApiModelProperty("报名者关联组织名称")
    @Column(name = "apply_user_org_name",length = 64, columnDefinition = "VARCHAR(64) COMMENT '报名者关联组织'")
    private String applyUserOrgName;

    @ApiModelProperty("审批状态")
    @Column(name = "approval_status", length = 64, columnDefinition = "VARCHAR(64) COMMENT '审批状态'")
    private String approvalStatus;

    @ApiModelProperty("审批人账号")
    @Column(name = "approval_user_account", length = 64, columnDefinition = "VARCHAR(64) COMMENT '审批状态'")
    private String approvalUserAccount;

    @ApiModelProperty("审批人名字")
    @Column(name = "approval_user_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '审批人名字'")
    private String approvalUserName;

    @ApiModelProperty("审批时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "approval_date", length = 64, columnDefinition = "datetime COMMENT '审批时间'")
    private Date approvalDate;

    /** 我签到的时间 */
    @ApiModelProperty("我签到的时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "my_attend_time", length = 64, columnDefinition = "datetime COMMENT '我签到的时间'")
    private Date myAttendTime;

    @ApiModelProperty("姓名")
    @Column(name = "name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '姓名'")
    private String name;

    @ApiModelProperty("性别")
    @Column(name = "sex", length = 64, columnDefinition = "VARCHAR(64) COMMENT '姓名'")
    private String sex;

    @ApiModelProperty("联系方式")
    @Column(name = "contact_phone", length = 64, columnDefinition = "VARCHAR(64) COMMENT '联系方式'")
    private String contactPhone;

    @ApiModelProperty("生日")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "birthday", length = 64, columnDefinition = "datetime COMMENT '生日'")
    private Date birthday;

    @ApiModelProperty("爱好")
    @Column(name = "hobby",length = 64, columnDefinition = "VARCHAR(64) COMMENT '爱好'")
    private String hobby;

    @ApiModelProperty("审批状态")
    @Column(name = "process_status",length = 64, columnDefinition = "VARCHAR(64) COMMENT '审批状态'")
    private String processStatus;

    /** 审批单号 */
    @ApiModelProperty("审批单号")
    @Column(name = "process_number", columnDefinition = "varchar(64) COMMENT '审批单号'")
    private String processNumber;

    @ApiModelProperty("报名用户名")
    @Column(name = "user_name", length = 64, columnDefinition = "varchar(64) COMMENT '报名用户名'")
    private String userName;

    @ApiModelProperty("是否签到（Y是N否）")
    @Column(name = "has_attend", length = 24, columnDefinition = "varchar(24) COMMENT '是否签到（Y是N否）'")
    private String hasAttend;

}
