package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;

/**
 * 活动管理-基础配置
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/16 10:54
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActivityManage", description = "活动管理-基础配置")
@Entity
@TableName("mms_activity_manage")
@Table(
        name = "mms_activity_manage")
@org.hibernate.annotations.Table(appliesTo = "mms_activity_manage", comment = "活动管理-基础配置")
public class ActivityManage extends TenantFlagOpEntity {


    @ApiModelProperty("活动编码")
    @Column(name = "code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动配置编码'")
    private String code;

    @ApiModelProperty("活动名称")
    @Column(name = "name",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动名称'")
    private String name;

    @ApiModelProperty("活动地址")
    @Column(name = "address",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动地址'")
    private String address;

    @ApiModelProperty("活动说明")
    @Column(name = "activity_dsc",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动说明'")
    private String activityDsc;

    @ApiModelProperty("报名是否需要审批")
    @Column(name = "need_approval",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '报名是否需要审批'")
    private String needApproval;

    @ApiModelProperty("报名是否需要审批")
    @Column(name = "need_approval_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '报名是否需要审批'")
    private String needApprovalName;

    @ApiModelProperty("报名人数上限数量")
    @Column(name = "apply_ceiling_num",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '报名是否需要审批'")
    private Integer applyCeilingNum;

    @ApiModelProperty("报名等级限制")
    @Column(name = "apply_require",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '报名等级限制'")
    private String applyRequire;

    @ApiModelProperty("报名等级限制名称")
    @Column(name = "apply_require_name",length = 64, columnDefinition = "VARCHAR(64) COMMENT '报名等级限制名称'")
    private String applyRequireName;

    @ApiModelProperty("报名时间（开始）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "apply_start_date", nullable = false, length = 64, columnDefinition = "datetime COMMENT '报名时间（开始）'")
    private Date applyStartDate;

    @ApiModelProperty("报名结束（结束）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "apply_end_date", nullable = false, length = 64, columnDefinition = "datetime COMMENT '报名时间（结束）'")
    private Date applyEndDate;

    @ApiModelProperty("签到时间（开始）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "sign_start_date", nullable = false, length = 64, columnDefinition = "datetime COMMENT '报名时间（开始）'")
    private Date signStartDate;

    @ApiModelProperty("签到结束（结束）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "sign_end_date", nullable = false, length = 64, columnDefinition = "datetime COMMENT '报名时间（结束）'")
    private Date signEndDate;

    @ApiModelProperty("活动详情")
    @Column(name = "activity_detail_desc", columnDefinition = "text COMMENT '活动详情'")
    private String activityDetailDesc;

    @Column(name = "file_id",  columnDefinition = "VARCHAR(255) COMMENT ' 文件id '")
    @ApiModelProperty("文件id")
    private String fileId;

    @Column(name = "file_name", columnDefinition = "VARCHAR(255) COMMENT ' 文件名 '")
    @ApiModelProperty("文件名")
    private String fileName;

    @ApiModelProperty("省")
    @TableField(value = "province_code")
    @Column(name = "province_code", length = 64, columnDefinition = "varchar(64) COMMENT '省'")
    private String provinceCode;

    @ApiModelProperty("省名称")
    @TableField(value = "province_name")
    @Column(name = "province_name", length = 128, columnDefinition = "varchar(128) COMMENT '省名称'")
    private String provinceName;

    @ApiModelProperty("市")
    @TableField(value = "city_code")
    @Column(name = "city_code", length = 64, columnDefinition = "varchar(64) COMMENT '市'")
    private String cityCode;

    @ApiModelProperty("市名称")
    @TableField(value = "city_name")
    @Column(name = "city_name", length = 128, columnDefinition = "varchar(128) COMMENT '市名称'")
    private String cityName;

    @ApiModelProperty("区")
    @TableField(value = "district_code")
    @Column(name = "district_code", length = 64, columnDefinition = "varchar(64) COMMENT '区'")
    private String districtCode;

    @ApiModelProperty("区名称")
    @TableField(value = "district_name")
    @Column(name = "district_name", length = 128, columnDefinition = "varchar(128) COMMENT '区名称'")
    private String districtName;

    @ApiModelProperty("已报名人数")
    @TableField(value = "has_join")
    @Column(name = "has_join", length = 6, columnDefinition = "int(5) COMMENT '已报名人数'")
    private Integer hasJoin;

    /** 活动对用户的状态 */
    @ApiModelProperty("活动对用户的状态")
    @Transient
    @TableField(exist = false)
    private String statusForUser;

    /** 活动自身状态 */
    @ApiModelProperty("活动自身状态")
    @Transient
    @TableField(exist = false)
    private String activityStatus;

    /** 具体用户报名审批状态 */
    @ApiModelProperty("具体用户报名审批状态")
    @Transient
    @TableField(exist = false)
    private String processStatus;

    /** 是否签到（Y/N） */
    @ApiModelProperty("是否签到（Y/N）")
    @Transient
    @TableField(exist = false)
    private String hasAttend;

    /** 审批通过（驳回）时间 */
    @ApiModelProperty("审批通过（驳回）时间")
    @Transient
    @TableField(exist = false)
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date approvalDate;

    @ApiModelProperty("我报名的时间")
    @TableField(exist = false)
    @Transient
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date applyDate;

    @ApiModelProperty("我签到的时间")
    @TableField(exist = false)
    @Transient
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date myAttendTime;
}
