package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @author hupan
 * @date 2023/6/30 11:38
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AddressManage", description = "地址管理")
@Entity
@TableName("mms_address_manage")
@Table(
    name = "mms_address_manage")
@org.hibernate.annotations.Table(appliesTo = "mms_address_manage", comment = "地址管理")
public class AddressManage extends TenantFlagOpEntity {

  @ApiModelProperty("收获人手机号")
  @Column(name="member_phone", length = 20, columnDefinition = "VARCHAR(20) COMMENT '会员手机号'")
  private String memberPhone;

  @ApiModelProperty("收货人姓名")
  @Column(name="member_name", length = 100, columnDefinition = "VARCHAR(100) COMMENT '会员姓名'")
  private String memberName;

  @ApiModelProperty("会员编码")
  @Column(name="member_code" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员编码'")
  private String memberCode;

  @ApiModelProperty("是否为默认地址,数据字典,0表示不是,1表示默认")
  @Column(name="flag_default_address", length = 20, columnDefinition = "VARCHAR(20) COMMENT '是否为默认地址'")
  private String flagDefaultAddress;

  @ApiModelProperty("省")
  @TableField(value = "province_code")
  @Column(name = "province_code", length = 64, columnDefinition = "varchar(64) COMMENT '省'")
  private String provinceCode;

  @ApiModelProperty("省名称")
  @TableField(value = "province_name")
  @Column(name = "province_name", length = 128, columnDefinition = "varchar(128) COMMENT '省名称'")
  private String provinceName;

  @ApiModelProperty("市")
  @TableField(value = "city_code")
  @Column(name = "city_code", length = 64, columnDefinition = "varchar(64) COMMENT '市'")
  private String cityCode;

  @ApiModelProperty("市名称")
  @TableField(value = "city_name")
  @Column(name = "city_name", length = 128, columnDefinition = "varchar(128) COMMENT '市名称'")
  private String cityName;

  @ApiModelProperty("区")
  @TableField(value = "district_code")
  @Column(name = "district_code", length = 64, columnDefinition = "varchar(64) COMMENT '区'")
  private String districtCode;

  @ApiModelProperty("区名称")
  @TableField(value = "district_name")
  @Column(name = "district_name", length = 128, columnDefinition = "varchar(128) COMMENT '区名称'")
  private String districtName;

  @ApiModelProperty("详细地址")
  @TableField(value = "detail_address")
  @Column(name = "detail_address", length = 200, columnDefinition = "varchar(200) COMMENT '详细地址'")
  private String detailAddress;
}
