package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/20 14:18
 * @description 用户答题记录
 */
@ApiModel(value = "AnswerRecord", description = "用户答题记录")
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mms_answer_record")
@Table(name = "mms_answer_record")
@org.hibernate.annotations.Table(appliesTo = "mms_answer_record", comment = "用户答题记录")
public class AnswerRecord extends TenantFlagOpEntity {
  @ApiModelProperty("答题记录编码")
  @Column(name = "code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '答题记录编码'")
  private String code;

  @ApiModelProperty("答题内容")
  @Column(name = "answer_value", length = 500, columnDefinition = "VARCHAR(500) COMMENT '答题内容值'")
  private String answerValue;

  @ApiModelProperty("题目编码")
  @Column(name = "question_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '题目编码'")
  private String questionCode;

  @ApiModelProperty("答题人编码")
  @Column(name = "member_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '答题人编码'")
  private String memberCode;
}
