package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/25 11:19
 * @description 问卷答题人基本信息
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mms_answer_member")
@Table(name = "mms_answer_member")
@org.hibernate.annotations.Table(appliesTo = "mms_answer_member", comment = "问卷答题人基本信息")
public class AnswerUser extends TenantFlagOpEntity {
  @ApiModelProperty("答题人编码")
  @Column(name = "member_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '答题人编码'")
  private String memberCode;

  @ApiModelProperty("答题人联系电话")
  @Column(name = "tel", length = 30, columnDefinition = "VARCHAR(30) COMMENT '答题人联系电话'")
  private String tel;

  @ApiModelProperty("问卷编码")
  @Column(name = "questionnaire_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '问卷编码'")
  private String questionnaireCode;

  @ApiModelProperty("参与问卷获得的积分")
  @Column(name = "obtain_points", length = 10, columnDefinition = "decimal(8,2) COMMENT '参与问卷获得的积分'")
  private BigDecimal obtainPoints;
}
