package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(description = "小程序积分商城列表兑换记录表")
@Entity
@TableName("mms_point_exchange")
@Table(
        name = "mms_point_exchange")
@org.hibernate.annotations.Table(appliesTo = "mms_point_exchange", comment = "小程序积分商城列表兑换记录表")
public class AppPointExchangeEntity extends TenantFlagOpEntity {

  @ApiModelProperty("上架编码")
  @Column(name = "shelf_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '上架编码'")
  private String shelfCode;

  @ApiModelProperty("商品编码")
  @Column(name = "product_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商品编码'")
  private String productCode;

  @ApiModelProperty("账户")
  @Column(name = "account", length = 64, columnDefinition = "VARCHAR(64) COMMENT '账户'")
  private String account;

  @ApiModelProperty("当日兑换数量")
  @Column(name = "current_day", length = 5, columnDefinition = "int(5) COMMENT '当日兑换数量'")
  private Integer currentDay;

  @ApiModelProperty("当月兑换数量")
  @Column(name = "current_month", length = 5, columnDefinition = "int(5) COMMENT '当月兑换数量'")
  private Integer currentMonth;

  @ApiModelProperty("当年兑换数量")
  @Column(name = "current_year", length = 5, columnDefinition = "int(5) COMMENT '当年兑换数量'")
  private Integer currentYear;

  @ApiModelProperty("账号已兑换数量（商品兑换次数限制维度为账号时该字段才有值）")
  @Column(name = "account_exchange", length = 5, columnDefinition = "int(5) COMMENT '账号已兑换数量（商品兑换次数限制维度为账号时该字段才有值）'")
  private Integer accountExchange;

  /** 商品兑换次数限制 */
  @Transient
  @TableField(exist = false)
  private int quantity;

  /** 商品兑换次数限制周期类型 */
  @Transient
  @TableField(exist = false)
  private String exchangePeriodName;

  /** 商品库存 */
  @Transient
  @TableField(exist = false)
  private int inventoryQuantity;



//  @ApiModelProperty("无限制")
//  @Column(name = "account_exchange", length = 5, columnDefinition = "int(5) COMMENT '无限制'")
//  private Integer accountExchange;

}
