package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author hupan
 * @date 2023/7/4 11:06
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mms_applet_popup_notify")
@Table(name = "mms_applet_popup_notify")
@org.hibernate.annotations.Table(appliesTo = "mms_applet_popup_notify", comment = "小程序弹窗表")
public class AppletPopupNotify extends TenantFlagOpEntity {

  @ApiModelProperty("会员编码")
  @Column(name = "member_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员编码'")
  private String memberCode;

  @ApiModelProperty("触发类型,枚举: 数据字典:mms_trigger_type,枚举:TriggerTypeEnum")
  @Column(name = "trigger_type", length = 30, columnDefinition = "VARCHAR(30) COMMENT '触发类型'")
  private String triggerType;

  @ApiModelProperty("触发条件,枚举: 数据字典:mms_trigger_condition,枚举:TriggerConditionEnum")
  @Column(name = "trigger_conditions", length = 30, columnDefinition = "VARCHAR(30) COMMENT '触发类型'")
  private String triggerConditions;

  @ApiModelProperty("触发标记(触发过标记为1,未触发标记为0,默认为0)")
  @Column(name = "trigger_flag", length = 30, columnDefinition = "VARCHAR(30) COMMENT '触发标记'")
  private String triggerFlag;

  @ApiModelProperty("权重")
  @Column(name = "trigger_weight", length = 64, columnDefinition = "VARCHAR(64) COMMENT '权重'")
  private String triggerWeight;

  @ApiModelProperty("弹窗开始时间")
  @TableField(value = "end_time")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "start_time", length = -1, columnDefinition = "datetime COMMENT '弹窗开始时间'")
  private Date startTime;

  @ApiModelProperty("弹窗结束时间")
  @TableField(value = "end_time")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "end_time", length = -1, columnDefinition = "datetime COMMENT '弹窗结束时间'")
  private Date endTime;

  @ApiModelProperty("弹窗图片")
  @Column(name = "file_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '弹窗图片'")
  private String fileId;

  @ApiModelProperty("弹窗对应url")
  @Column(name = "skip_url", length = 64, columnDefinition = "VARCHAR(64) COMMENT '弹窗对应url'")
  private String skipUrl;

  @ApiModelProperty("跳转类型,枚举: 数据字典:mms_skip_type,枚举:SkipTypeEnum")
  @Column(name = "skip_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '跳转类型(内部跳转/外部跳转),枚举:'")
  private String skipType;

  @ApiModelProperty("外部跳转对应的appId")
  @Column(name = "app_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '外部跳转对应的appId'")
  private String appId;
}
