package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 权益管理
 * @author zouhs
 * @date 2023/6/12
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "BenefitsManage", description = "权益管理")
@Entity
@TableName("mms_benefits_manage")
@Table(
    name = "mms_benefits_manage",
    indexes = {
        @Index(name = "mms_benefits_manage_index1", columnList = "code",unique = true),
    })
@org.hibernate.annotations.Table(appliesTo = "mms_benefits_manage", comment = "权益管理")
public class BenefitsManage extends TenantFlagOpEntity {

  @ApiModelProperty("权益编码")
  @Column(name = "code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '权益编码'")
  private String code;

  @ApiModelProperty("权益名称")
  @Column(name = "name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '权益名称'")
  private String name;

  @ApiModelProperty("权益类型,数据字典:mms_benefits_type,枚举:BenefitsTypeEnum")
  @Column(name = "type", length = 10, columnDefinition = "VARCHAR(10) COMMENT '权益类型'")
  private String type;

  @ApiModelProperty("单位,数据字典:mms_benefits_unit,枚举:BenefitsUnitEnum")
  @Column(name = "unit", length = 10, columnDefinition = "VARCHAR(10) COMMENT '单位'")
  private String unit;

  @ApiModelProperty("产品图片")
  @Column(name = "product_image", length = 100, columnDefinition = "VARCHAR(100) COMMENT '产品图片'")
  private String productImage;

  @ApiModelProperty("产品详情")
  @Column(name = "product_desc", length = 0, columnDefinition = "text COMMENT '产品详情'")
  private String productDesc;

  @ApiModelProperty("兑换有效期(月)")
  @Column(name = "exchange_valid_period", length = 5, columnDefinition = "int(5) COMMENT '兑换有效期(月)'")
  private Integer exchangeValidPeriod;

  @ApiModelProperty("使用有效期(天)")
  @Column(name = "use_valid_period", length = 5, columnDefinition = "int(5) COMMENT '使用有效期(天)'")
  private Integer useValidPeriod;

}
