package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 权益管理-区域有效期配置
 * @author zouhs
 * @date 2023/6/12
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "BenefitsManageOrg", description = "权益管理-区域有效期配置")
@Entity
@TableName("mms_benefits_manage_org")
@Table(
    name = "mms_benefits_manage_org",
    indexes = {
        @Index(name = "mms_benefits_manage_org_index1", columnList = "benefits_manage_id"),
        @Index(name = "mms_benefits_manage_org_index2", columnList = "benefits_manage_code")
    })
@org.hibernate.annotations.Table(appliesTo = "mms_benefits_manage_org", comment = "权益管理-区域有效期配置")
public class BenefitsManageOrg extends TenantFlagOpEntity {

  @ApiModelProperty("权益ID")
  @Column(name = "benefits_manage_id", length = 32, columnDefinition = "VARCHAR(32) COMMENT '权益ID'")
  private String benefitsManageId;

  @ApiModelProperty("权益编码")
  @Column(name = "benefits_manage_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '权益编码'")
  private String benefitsManageCode;

  @ApiModelProperty("组织编码")
  @Column(name = "org_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '组织编码'")
  private String orgCode;

  @ApiModelProperty("组织名称")
  @Column(name = "org_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '组织名称'")
  private String orgName;

  @ApiModelProperty("兑换有效期(月)")
  @Column(name = "exchange_valid_period", length = 5, columnDefinition = "int(5) COMMENT '兑换有效期(月)'")
  private Integer exchangeValidPeriod;

  @ApiModelProperty("使用有效期(天)")
  @Column(name = "use_valid_period", length = 5, columnDefinition = "int(5) COMMENT '使用有效期(天)'")
  private Integer useValidPeriod;

}
