package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author hupan
 * @date 2023/6/29 11:27
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "BenefitsTransferRecord", description = "权益转移记录表")
@Entity
@TableName("mms_benefits_transfer_record")
@Table(name = "mms_benefits_transfer_record")
@org.hibernate.annotations.Table(appliesTo = "mms_benefits_transfer_record", comment = "权益转移记录表")
public class BenefitsTransferRecord extends TenantFlagOpEntity {

  @ApiModelProperty("权益转入对象")
  @Column(name = "transfer_to_object_name",length = 100, columnDefinition = "VARCHAR(100) COMMENT '权益转入对象'")
  private String transferToObjectName;

  @ApiModelProperty("权益转入对象手机号")
  @Column(name="transfer_to_object_phone", length = 20, columnDefinition = "VARCHAR(20) COMMENT '权益转入对象手机号'")
  private String transferToObjectPhone;

  @ApiModelProperty("权益转出对象")
  @Column(name = "transfer_out_object_name",length = 100, columnDefinition = "VARCHAR(100) COMMENT '权益转出对象'")
  private String transferOutObjectName;

  @ApiModelProperty("权益转出对象手机号")
  @Column(name="transfer_out_object_phone", length = 20, columnDefinition = "VARCHAR(20) COMMENT '权益转出对象手机号'")
  private String transferOutObjectPhone;

  @ApiModelProperty("操作人")
  @Column(name = "operator_name",length = 100, columnDefinition = "VARCHAR(100) COMMENT '操作人'")
  private String operatorName;

  @ApiModelProperty("权益转移时间")
  @TableField(value = "transfer_time")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "transfer_time", length = -1, columnDefinition = "datetime COMMENT '权益转移时间'")
  private Date transferTime;

  @ApiModelProperty("会员等级")
  @Column(name = "member_level", length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员等级'")
  private String memberLevel;

  @ApiModelProperty("成长值")
  @Column(name = "growth_value", length = 11, columnDefinition = "int(11) COMMENT '成长值'")
  private Integer growthValue;

  @ApiModelProperty("实物")
  @Column(name = "substance",length = 100, columnDefinition = "VARCHAR(100) COMMENT '实物'")
  private String substance;

  @ApiModelProperty("虚拟")
  @Column(name = "virtually",length = 100, columnDefinition = "VARCHAR(100) COMMENT '虚拟'")
  private String virtually;

  @ApiModelProperty("酒卡")
  @Column(name = "wine_card",length = 100, columnDefinition = "VARCHAR(100) COMMENT '酒卡'")
  private String wineCard;

  @ApiModelProperty("积分")
  @Column(name = "integral", length = 11, columnDefinition = "int(11) COMMENT '积分'")
  private Integer integral;

}
