package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * TODO
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/20 18:09
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CardProduct", description = "名片商品")
@Entity
@TableName("mms_card_product")
@Table(
        name = "mms_card_product")
@org.hibernate.annotations.Table(appliesTo = "mms_card_product", comment = "名片商品")
public class CardProduct extends TenantFlagOpEntity {

    @ApiModelProperty("名片编码")
    @Column(name = "code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '节日编码'")
    private String code;

    @ApiModelProperty("商品名称")
    @Column(name = "name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '节日名称'")
    private String name;

    @Column(name = "file_id",  columnDefinition = "VARCHAR(255) COMMENT ' 产品文件id '")
    @ApiModelProperty("产品文件id")
    private String fileId;

    @Column(name = "file_name",  columnDefinition = "VARCHAR(255) COMMENT ' 产品文件名 '")
    @ApiModelProperty("产品文件名")
    private String fileName;

    @Column(name = "product_file_id",  columnDefinition = "VARCHAR(255) COMMENT ' 产品详情文件id '")
    @ApiModelProperty("产品详情文件id")
    private String productFileId;

    @Column(name = "product_file_name",  columnDefinition = "VARCHAR(255) COMMENT ' 产品详情文件名 '")
    @ApiModelProperty("产品详情文件名")
    private String productFileName;
}
