package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/16 16:39
 * @description 精选分类管理
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ChoiceNessCategory", description = "资讯分类管理")
@Entity
@TableName("mms_choice_ness_category_manage")
@Table(name = "mms_choice_ness_category_manage")
@org.hibernate.annotations.Table(appliesTo = "mms_choice_ness_category_manage", comment = "资讯分类管理")
public class ChoiceNessCategory extends TenantFlagOpEntity {

  @ApiModelProperty("精选分类编码")
  @Column(name = "code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '精选分类编码'")
  private String code;

  @ApiModelProperty("精选分类")
  @Column(name = "choice_ness_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '精选分类'")
  private String choiceNessName;

  @ApiModelProperty("排序")
  @Column(name = "choice_sort", length = 5, columnDefinition = "int(5) COMMENT '精选分类排序'")
  private Integer choiceSort;

  @ApiModelProperty("分类图片")
  @Column(name = "category_pic", length = 100, columnDefinition = "VARCHAR(100) COMMENT '分类图片'")
  private String categoryPic;

}
