package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author hupan
 * @date 2023/6/19 11:25
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CulturalAndTourismRespondent", description = "文旅答题题目回答表")
@Entity
@TableName("mms_cultural_tourism_respondent")
@Table(name = "mms_cultural_tourism_respondent")
@org.hibernate.annotations.Table(appliesTo = "mms_cultural_tourism_respondent", comment = "文旅答题题目回答表")
public class CulturalAndTourismRespondent extends TenantFlagOpEntity {

  @ApiModelProperty("题目编码")
  @Column(name = "code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '题目编码'")
  private String code;

  @ApiModelProperty("题目标题")
  @Column(name = "title", length = 64, columnDefinition = "VARCHAR(64) COMMENT '题目标题'")
  private String title;

  @ApiModelProperty("正确答案")
  @Column(name = "right_answer", length = 64, columnDefinition = "VARCHAR(64) COMMENT '正确答案'")
  private String rightAnswer;

  @ApiModelProperty("选择答案")
  @Column(name = "select_answer", length = 64, columnDefinition = "VARCHAR(64) COMMENT '选择答案'")
  private String selectAnswer;

  @ApiModelProperty("答题结果,true或者false")
  @Column(name = "answer_result", length = 64, columnDefinition = "VARCHAR(64) COMMENT '答题结果'")
  private String answerResult;

  @ApiModelProperty("答题人手机号")
  @Column(name = "phone", length = 64, columnDefinition = "VARCHAR(64) COMMENT '答题人手机号'")
  private String phone;

  @ApiModelProperty("答题人姓名")
  @Column(name = "name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '答题人姓名'")
  private String name;

  @ApiModelProperty("答题时间")
  @TableField(value = "answer_time")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "answer_time", length = -1, columnDefinition = "datetime COMMENT '答题时间'")
  private Date answerTime;

  @ApiModelProperty("获得积分")
  @Column(name = "points", length = 5, columnDefinition = "int(5) COMMENT '答题积分'")
  private Integer points;
}
