package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @author hupan
 * @date 2023/6/19 11:15
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CulturalAndTourismTopic", description = "文旅答题题目管理表")
@Entity
@TableName("mms_cultural_tourism_topic")
@Table(name = "mms_cultural_tourism_topic")
@org.hibernate.annotations.Table(appliesTo = "mms_cultural_tourism_topic", comment = "文旅答题题目管理表")
public class CulturalAndTourismTopic extends TenantFlagOpEntity {

  @ApiModelProperty("题目编码")
  @Column(name = "code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '题目编码'")
  private String code;

  @ApiModelProperty("题目标题")
  @Column(name = "title", length = 64, columnDefinition = "VARCHAR(64) COMMENT '题目标题'")
  private String title;

  @ApiModelProperty("题目选项的json值")
  @Column(name = "title_option", length = 500, columnDefinition = "VARCHAR(500) COMMENT '题目选项的json值'")
  private String titleOption;

  @ApiModelProperty("题目答案")
  @Column(name = "answer", length = 64, columnDefinition = "VARCHAR(64) COMMENT '题目答案'")
  private String answer;

  @ApiModelProperty("题目解析")
  @Column(name = "analysis", length = 500, columnDefinition = "VARCHAR(500) COMMENT '题目解析'")
  private String analysis;

  @ApiModelProperty("提交次数")
  @Column(name = "commit_times", length = 5, columnDefinition = "int(5) COMMENT '提交次数'")
  private Integer commitTimes;

  @ApiModelProperty("正确次数")
  @Column(name = "correct_times", length = 5, columnDefinition = "int(5) COMMENT '正确次数'")
  private Integer correctTimes;

  @ApiModelProperty("提交人数")
  @Column(name = "commit_people_times", length = 5, columnDefinition = "int(5) COMMENT '提交人数'")
  private Integer commitPeopleTimes;

  @ApiModelProperty("正确人数")
  @Column(name = "correct_people_times", length = 5, columnDefinition = "int(5) COMMENT '正确人数'")
  private Integer correctPeopleTimes;
}
