package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @author hupan
 * @date 2023/6/14 11:11
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DeliveryPermissionManage", description = "配送权限管理")
@Entity
@TableName("mms_delivery_permission_manage")
@Table(name = "mms_delivery_permission_manage")
@org.hibernate.annotations.Table(appliesTo = "mms_delivery_permission_manage", comment = "配送权限管理")
public class DeliveryPermissionManage extends TenantFlagOpEntity {

  @ApiModelProperty("组织编码")
  @Column(name = "org_code",
      length = 64,
      columnDefinition = "varchar(64) COMMENT '组织编码'")
  private String orgCode;

  @ApiModelProperty("组织名称")
  @Column(name = "org_name",
      length = 64,
      columnDefinition = "VARCHAR(64) COMMENT '组织名称'")
  private String orgName;

  @ApiModelProperty("是否有自主配送的权限，0表示无，1表示有")
  @Column(name = "has_self_delivery_permission",
      length = 5,
      columnDefinition = "int(5) COMMENT '自主配送的权限，0表示无，1表示有'")
  private String hasSelfDeliveryPermission;
}
