package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/19 13:34
 * @description 评论实体类
 */

@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "InfoCategory",description = "资讯分类管理")
@Entity
@TableName("mms_discuss")
@Table(name = "mms_discuss")
@org.hibernate.annotations.Table(appliesTo = "mms_discuss", comment = "评论管理")
public class Discuss extends TenantFlagOpEntity {
  @ApiModelProperty("评论编码")
  @Column(name = "code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '评论编码'")
  private String code;

  @ApiModelProperty("序号")
  @Column(name = "serial_num", length = 5, columnDefinition = "int(5) COMMENT '序号'")
  private Integer serialNum;

  @ApiModelProperty("资讯编码")
  @Column(name = "info_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '资讯编码'")
  private String infoCode;

  @ApiModelProperty("资讯标题")
  @Column(name = "info_title", length = 64, columnDefinition = "VARCHAR(64) COMMENT '资讯标题'")
  private String infoTitle;

  @ApiModelProperty("精选，(0||1)==>（不是||是）")
  @Column(name = "choice_discuss", length = 1, columnDefinition = "tinyint(1) COMMENT '精选，(0||1)==>（不是||是）'")
  private Integer choiceDiscuss;

  @ApiModelProperty("评论人手机号")
  @Column(name = "discuss_tel", length = 30 ,columnDefinition = "VARCHAR(30) COMMENT '评论人手机号'")
  private String discussTel;

  @ApiModelProperty("评论内容")
  @Column(name = "discuss_content", length = 255, columnDefinition = "VARCHAR(255) COMMENT '评论内容'")
  private String discussContent;

  @ApiModelProperty("审批状态,字典:mms_discuss_check_status,枚举:DiscussCheckStatusEnum")
  @Column(name = "check_status", length = 64, columnDefinition = "VARCHAR(64) COMMENT '审批状态'")
  private String checkStatus;

  @ApiModelProperty("会员编码")
  @Column(name = "member_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员编码'")
  private String memberCode;
}
