package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 虚拟订单
 * @author zouhs
 * @date 2023/6/13
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DummyOrderUser", description = "虚拟订单用户信息")
@Entity
@TableName("mms_dummy_order_user")
@Table(
    name = "mms_dummy_order_user",
    indexes = {
        @Index(name = "mms_dummy_order_user_index1", columnList = "order_code"),
    })
@org.hibernate.annotations.Table(appliesTo = "mms_dummy_order_user", comment = "虚拟订单用户信息")
public class DummyOrderUser extends TenantFlagOpEntity {

  @ApiModelProperty("订单号")
  @Column(name = "order_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '订单号'")
  private String orderCode;

  @ApiModelProperty("姓名")
  @Column(name = "name", length = 45, columnDefinition = "VARCHAR(45) COMMENT '姓名'")
  private String name;

  @ApiModelProperty("联系方式")
  @Column(name = "phone", length = 20, columnDefinition = "VARCHAR(20) COMMENT '联系方式'")
  private String phone;

}
