package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * 节日
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/20 17:17
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "HolidayEntity", description = "节日")
@Entity
@TableName("mms_holiday")
@Table(
        name = "mms_holiday")
@org.hibernate.annotations.Table(appliesTo = "mms_holiday", comment = "节日")
public class HolidayEntity extends TenantFlagOpEntity {

    @ApiModelProperty("节日编码")
    @Column(name = "code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '节日编码'")
    private String code;

    @ApiModelProperty("节日名称")
    @Column(name = "name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '节日名称'")
    private String name;

    @ApiModelProperty("节日类型")
    @Column(name = "type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '节日类型'")
    private String type;

    @ApiModelProperty("节日日期开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "holiday_start_date", columnDefinition = "datetime COMMENT '节日日期开始时间'")
    private Date holidayStartDate;

    @ApiModelProperty("节日日期结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "holiday_end_date", columnDefinition = "datetime COMMENT '节日日期结束时间'")
    private Date holidayEndDate;

    @ApiModelProperty("单个用户额外积分上限")
    @Column(name = "extra_integral_top", columnDefinition = "int(10) COMMENT '单个用户额外积分上限'")
    private Integer extraIntegralTop;


}
