package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 节日积分倍数
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/20 17:26
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "HolidayIntegral", description = "节日积分倍数")
@Entity
@TableName("mms_holiday_integral")
@Table(
        name = "mms_holiday_integral")
@org.hibernate.annotations.Table(appliesTo = "mms_holiday_integral", comment = "节日积分倍数")
public class HolidayIntegral extends TenantFlagOpEntity {


    @ApiModelProperty("节日编码")
    @Column(name = "holiday_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '节日编码'")
    private String holidayCode;

    @ApiModelProperty("渠道")
    @Column(name = "channel", length = 64, columnDefinition = "VARCHAR(64) COMMENT '渠道'")
    private String channel;

    @ApiModelProperty("渠道名称")
    @Column(name = "channel_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '渠道名称'")
    private String channelName;

    @ApiModelProperty("节日积分倍数")
    @Column(name = "multiple", columnDefinition = "decimal(10,2) COMMENT '节日积分倍数'")
    private BigDecimal multiple;
}
