package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 会员节日获取积分记录
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/28 12:05
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "HolidayIntegralRecord", description = "会员节日获取积分记录")
@Entity
@TableName("mms_holiday_integral_record")
@Table(
        name = "mms_holiday_integral_record")
@org.hibernate.annotations.Table(appliesTo = "mms_holiday_integral_record", comment = "会员节日获取积分记录")
public class HolidayIntegralRecord extends TenantFlagOpEntity {

    @ApiModelProperty("节日编码")
    @Column(name = "holiday_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '节日编码'")
    private String holidayCode;

    @ApiModelProperty("会员手机号")
    @Column(name = "member_phone", length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员手机号'")
    private String memberPhone;

    @ApiModelProperty("会员编码")
    @Column(name = "member_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员编码'")
    private String memberCode;

    @ApiModelProperty("获取积分数量")
    @Column(name = "integral_num", length = 64, columnDefinition = "decimal(10,0) COMMENT '获取积分数量'")
    private BigDecimal integralNum;

    @ApiModelProperty("获取积分额外数量")
    @Column(name = "extra_integral_num", length = 64, columnDefinition = "decimal(10,0) COMMENT '获取积分额外数量'")
    private BigDecimal extraIntegralNum;

    @ApiModelProperty("获取渠道")
    @Column(name = "channel", length = 64, columnDefinition = "VARCHAR(64) COMMENT '获取渠道'")
    private String channel;
}
