package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 行业管理
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/12 16:12
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "IndustryEntity", description = "行业")
@Entity
@TableName("mms_industry")
@Table(
        name = "mms_industry")
@org.hibernate.annotations.Table(appliesTo = "mms_industry", comment = "行业")
public class IndustryEntity extends TenantFlagOpEntity {


    @ApiModelProperty("行业编码")
    @Column(name = "code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '行业编码'")
    private String code;

    @ApiModelProperty("行业名称")
    @Column(name = "name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '行业名称'")
    private String name;

}
