package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/16 10:24
 * @description 资讯分类管理
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "InfoCategory",description = "资讯分类管理")
@Entity
@TableName("mms_info_category_manage")
@Table(name = "mms_info_category_manage")
@org.hibernate.annotations.Table(appliesTo = "mms_info_category_manage", comment = "资讯分类管理")
public class InfoCategory extends TenantFlagOpEntity {

  @ApiModelProperty("资讯分类编码")
  @Column(name = "code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '资讯分类编码'")
  private String code;

  @ApiModelProperty("资讯分类")
  @Column(
      name = "info_name",
      length = 64,
      columnDefinition = "VARCHAR(64) COMMENT '资讯分类'"
  )
  private String infoName;

  @ApiModelProperty("排序")
  @Column(
      name = "info_sort",
      length = 5,
      columnDefinition = "int(5) COMMENT '资讯分类排序'"
  )
  private Integer infoSort;

  @ApiModelProperty("应用范围，数据字典:mms_info_category,枚举:InfoCategoryRangeEnum")
  @Column(
      name = "apply_range",
      length = 64,
      columnDefinition = "VARCHAR(64) COMMENT '应用范围'"
  )
  private String applyRange;


}
