package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/16 18:00
 * @description 资讯管理
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "InfoManage",description = "资讯管理")
@Entity
@TableName("mms_info_manage")
@Table(name = "mms_info_manage")
@org.hibernate.annotations.Table(appliesTo = "mms_info_manage", comment = "资讯管理")
public class InfoManage extends TenantFlagOpEntity {
  @ApiModelProperty("资讯编码")
  @Column(name = "code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '资讯编码'")
  private String code;

  @ApiModelProperty("序号")
  @Column(name = "serial_num", length = 5, columnDefinition = "int(5) COMMENT '序号'")
  private Integer  serialNum;

  @ApiModelProperty("标题")
  @Column(name = "info_title", length = 64, columnDefinition = "VARCHAR(64) COMMENT '标题'")
  private String infoTitle;

  @ApiModelProperty("开始时间")
  @Column(name = "start_time", length = 20, columnDefinition = "datetime COMMENT '开始时间'")
  private Date startTime;

  @ApiModelProperty("结束时间")
  @Column(name = "end_time", length = 20 ,columnDefinition = "datetime COMMENT '结束时间'")
  private Date endTime;

  @ApiModelProperty("应用模块,数据字典:mms_info_apply_model,枚举:InfoApplyModelEnum")
  @Column(name = "apply_model", length = 64, columnDefinition = "VARCHAR(64) COMMENT '应用模块'")
  private String applyModel;

  @ApiModelProperty("资讯分类===》对应资讯分类中的资讯编码code")
  @Column(name = "info_category", length = 64, columnDefinition = "VARCHAR(64) COMMENT '资讯分类'")
  private String infoCategory;

  @ApiModelProperty("资讯分类名")
  @Column(name = "info_category_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '资讯分类名'")
  private String infoCategoryName;

  @ApiModelProperty("资讯类型,数据字典:mms_info_manage_type,枚举:InfoTypeEnum")
  @Column(name = "info_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '资讯类型'")
  private String infoType;

  @ApiModelProperty("精选分类========》对应精选分类中的精选编码code")
  @Column(name = "choice_ness_category", length = 64, columnDefinition = "VARCHAR(64) COMMENT '精选分类'")
  private String choiceNessCategory;

  @ApiModelProperty("精选分类名")
  @Column(name = "choice_ness_category_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '精选分类名'")
  private String choiceNessCategoryName;

  @ApiModelProperty("封面图")
  @Column(name = "over_pic", length = 100, columnDefinition = "VARCHAR(100) COMMENT '封面图'")
  private String overPic;

  @ApiModelProperty("分享图")
  @Column(name = "share_pic", length = 100, columnDefinition = "VARCHAR(100) COMMENT '分享图'")
  private String sharePic;

  @ApiModelProperty("图文详情")
  @Column(name = "info_detail", length = 0, columnDefinition = "text COMMENT '图文详情'")
  private String infoDetail;

  @ApiModelProperty("跳转链接")
  @Column(name = "target_url", length = 100 , columnDefinition = "VARCHAR(100) COMMENT '跳转链接'")
  private String targetUrl;

  @ApiModelProperty("资讯阅读量")
  @Column(name = "read_num", length = 5, columnDefinition = "int(5) COMMENT '资讯阅读量'")
  private Integer readNum;
}
