package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/19 16:11
 * @description 资讯点赞实体类
 */
@ApiModel(value = "InfoUpvote", description = "资讯点赞实体类")
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mms_info_upvote")
@Table(name = "mms_info_upvote")
@org.hibernate.annotations.Table(appliesTo = "mms_info_upvote", comment = "资讯点赞实体类")
public class InfoUpvote extends TenantFlagOpEntity {

  @ApiModelProperty("资讯编码")
  @Column(name = "info_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '资讯编码'")
  private String infoCode;

  @ApiModelProperty("会员编码")
  @Column(name = "member_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员编码'")
  private String memberCode;

}
