package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 标签管理
 * @author hupan
 * @date 2023/6/13
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "Label", description = "标签管理")
@Entity
@TableName("mms_label_manage")
@Table(
    name = "mms_label_manage")
@org.hibernate.annotations.Table(appliesTo = "mms_label_manage", comment = "标签管理")
public class Label extends TenantFlagOpEntity {

    @ApiModelProperty("标签名称")
    @Column(
        name = "name",
        length = 64,
        columnDefinition = "VARCHAR(64) COMMENT '标签名称'")
    private String name;

    @ApiModelProperty("标签编码")
    @Column(
        name = "code",
        length = 64,
        columnDefinition = "VARCHAR(64) COMMENT '标签编码'"
    )
    private String code;

    @ApiModelProperty("标签分类名称=>对应标签分类管理的名称")
    @Column(name = "category_name",
        length = 64,
        columnDefinition = "VARCHAR(64) COMMENT '标签种类名称'")
    private String categoryName;

    @ApiModelProperty("标签分类编码")
    @Column(
        name = "category_code",
        length = 64,
        columnDefinition = "VARCHAR(64) COMMENT '标签分类编码'"
    )
    private String categoryCode;

    @ApiModelProperty("标签类型,数据字典mms_label_manage,枚举LabelManageEnum")
    @Column(name = "type",
        length = 5,
        columnDefinition = "VARCHAR(64) COMMENT '标签类型,数据字典mms_label_manage,枚举LabelManageEnum'")
    private String type;

    @ApiModelProperty("会员数量，预留字段，暂时没有值")
    @Column(name = "member_number",
        length = 5,
        columnDefinition = "int(5) COMMENT '会员数量'")
    private Integer memberNumber;

    @ApiModelProperty("会员数量排名，预留字段，暂时没有值")
    @Column(name = "member_sort",
        length = 5,
        columnDefinition = "int(5) COMMENT '会员数量排名'")
    private Integer memberSort;

}
