package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 标签分类管理
 *
 * @author hupan
 * @date 2023/6/13
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "LabelCategory", description = "标签种类管理")
@Entity
@TableName("mms_label_category_manage")
@Table(
    name = "mms_label_category_manage")
@org.hibernate.annotations.Table(appliesTo = "mms_label_category_manage", comment = "标签种类管理")
public class LabelCategory extends TenantFlagOpEntity {

  @ApiModelProperty("标签种类名称")
  @Column(name = "name",
      length = 64,
      columnDefinition = "VARCHAR(64) COMMENT '标签种类名称'")
  private String name;

  @ApiModelProperty("标签排序")
  @Column(name = "sort",
      length = 5,
      columnDefinition = "int(5) COMMENT '标签排序'")
  private int sort;

  @ApiModelProperty("标签分类编码")
  @Column(name = "code",
      length = 64,
      columnDefinition = "VARCHAR(64) COMMENT '标签分类编码'")
  private String code;

}
