package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 标签详细信息
 * @author hupan
 * @date 2023/6/13
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "LabelDetail", description = "标签详细信息")
@Entity
@TableName("mms_label_detail_manage")
@Table(name = "mms_label_detail_manage")
@org.hibernate.annotations.Table(appliesTo = "mms_label_detail_manage", comment = "标签详细信息")
public class LabelDetail extends TenantFlagOpEntity {

    @ApiModelProperty("标签表的主键，用于关联标签表")
    @Column(
        name = "label_code",
        length = 64,
        columnDefinition = "VARCHAR(64) COMMENT '标签表的编码'"
    )
    private String labelCode;

    @ApiModelProperty("条件类型,数据字典:mms_label_detail_enum,枚举:LabelDetailEnum")
    @Column(
        name = "condition_type",
        length = 20,
        columnDefinition = "VARCHAR(20) COMMENT '条件类型'"
    )
    private String conditionType;

    @ApiModelProperty("条件区间的最小值")
    @Column(
        name = "min",
        length = 11,
        columnDefinition = "int(11) COMMENT '条件区间的最小值'"
    )
    private Integer min;

    @ApiModelProperty("条件区间的最大值")
    @Column(
        name = "max",
        length = 11,
        columnDefinition = "int(11) COMMENT '条件区间的最大值'"
    )
    private Integer max;

    @ApiModelProperty("等级名称")
    @Column(name = "level_name",
        length = 64,
        columnDefinition = "VARCHAR(64) COMMENT '等级名称'")
    private String levelName;

    @ApiModelProperty("等级编码")
    @Column(name = "level_code",
    length = 64,
    columnDefinition = "VARCHAR(64) COMMENT '等级编码'")
    private String levelCode;
}
