package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 等级管理
 * @author zouhs
 * @date 2023/6/12
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "LevelManage", description = "等级管理")
@Entity
@TableName("mms_level_manage")
@Table(
    name = "mms_level_manage",
  indexes = {
      @Index(name = "mms_level_manage_index1", columnList = "level_code",unique = true),
  })
@org.hibernate.annotations.Table(appliesTo = "mms_level_manage", comment = "等级管理")
public class LevelManage extends TenantFlagOpEntity {

  @ApiModelProperty("等级编码")
  @Column(name = "level_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '等级编码'")
  private String levelCode;

  @ApiModelProperty("等级")
  @Column(name = "level_num", length = 2, columnDefinition = "int(2) COMMENT '等级'")
  private Integer levelNum;

  @ApiModelProperty("等级名称")
  @Column(name = "level_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '等级名称'")
  private String levelName;

  @ApiModelProperty("成长值区间开始")
  @Column(name = "grow_start", length = 11, columnDefinition = "int(11) COMMENT '成长值区间开始'")
  private Integer growStart;

  @ApiModelProperty("成长值区间结束")
  @Column(name = "grow_end", length = 11, columnDefinition = "int(11) COMMENT '成长值区间结束'")
  private Integer growEnd;

  @ApiModelProperty("第一年该等级卡片")
  @Column(name = "card_image_one", length = 100, columnDefinition = "VARCHAR(100) COMMENT '第一年该等级卡片'")
  private String cardImageOne;

  @ApiModelProperty("连续一年以上等级卡片")
  @Column(name = "card_image_two", length = 100, columnDefinition = "VARCHAR(100) COMMENT '连续一年以上等级卡片'")
  private String cardImageTwo;

  @ApiModelProperty("权益展示会员卡片")
  @Column(name = "card_image_three", length = 100, columnDefinition = "VARCHAR(100) COMMENT '权益展示会员卡片'")
  private String cardImageThree;

  @ApiModelProperty("到期扣除比例")
  @Column(name = "expire_deduct_ratio", length = 20, columnDefinition = "decimal(18,2) COMMENT '到期扣除比例'")
  private BigDecimal expireDeductRatio;

  @ApiModelProperty("激活成长值")
  @Column(name = "active_grow", length = 11, columnDefinition = "int(11) COMMENT '激活成长值'")
  private Integer activeGrow;

  @ApiModelProperty("16进制背景颜色")
  @Column(name = "background_color", length = 30, columnDefinition = "VARCHAR(30) COMMENT '16进制背景颜色'")
  private String backgroundColor;

}
