package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 等级管理-权益配置
 * @author zouhs
 * @date 2023/6/12
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "LevelManageBenefits", description = "等级管理-权益配置")
@Entity
@TableName("mms_level_manage_benefits")
@Table(
    name = "mms_level_manage_benefits",
    indexes = {
    @Index(name = "mms_level_manage_benefits_index1", columnList = "level_code"),
    @Index(name = "mms_level_manage_benefits_index2", columnList = "code")
})
@org.hibernate.annotations.Table(appliesTo = "mms_level_manage_benefits", comment = "等级管理-权益配置")
public class LevelManageBenefits extends TenantFlagOpEntity {

  @ApiModelProperty("等级编码")
  @Column(name = "level_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '等级编码'")
  private String levelCode;

  @ApiModelProperty("权益编码")
  @Column(name = "code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '权益编码'")
  private String code;

  @ApiModelProperty("权益名称")
  @Column(name = "name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '权益名称'")
  private String name;

  @ApiModelProperty("排序")
  @Column(name = "seq", length = 5, columnDefinition = "int(5) COMMENT '排序'")
  private Integer seq;

  @ApiModelProperty("是否固定")
  @Column(name = "flag_fixed", length = 5, columnDefinition = "VARCHAR(5) COMMENT '是否固定'")
  private String flagFixed;

  @ApiModelProperty("连续x年该等级会员以上")
  @Column(name = "year_num", length = 5, columnDefinition = "int(5) COMMENT '排序'")
  private Integer yearNum;

}
