package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 等级管理-权益配置明细
 * @author zouhs
 * @date 2023/6/12
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "LevelManageBenefitsDetail", description = "等级管理-权益配置明细")
@Entity
@TableName("mms_level_manage_benefits_detail")
@Table(
    name = "mms_level_manage_benefits_detail",
    indexes = {
        @Index(name = "mms_level_manage_benefits_detail_index1", columnList = "level_manage_benefits_code"),
        @Index(name = "mms_level_manage_benefits_detail_index2", columnList = "code"),
        @Index(name = "mms_level_manage_benefits_detail_index3", columnList = "level_code"),
    })
@org.hibernate.annotations.Table(appliesTo = "mms_level_manage_benefits_detail", comment = "等级管理-权益配置明细")
public class LevelManageBenefitsDetail extends TenantFlagOpEntity {

    @ApiModelProperty("等级编码")
    @Column(name = "level_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '等级编码'")
    private String levelCode;

    @ApiModelProperty("等级关联权益")
    @Column(name = "level_manage_benefits_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '权益编码'")
    private String levelManageBenefitsCode;

    @ApiModelProperty("权益编码")
    @Column(name = "code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '权益编码'")
    private String code;

    @ApiModelProperty("权益名称")
    @Column(name = "name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '权益名称'")
    private String name;

    @ApiModelProperty("权益类型,数据字典:mms_benefits_type,枚举:BenefitsTypeEnum")
    @Column(name = "type", length = 10, columnDefinition = "VARCHAR(10) COMMENT '权益类型'")
    private String type;

    @ApiModelProperty("说明")
    @Column(name = "remark_desc", length = 255, columnDefinition = "VARCHAR(255) COMMENT '说明'")
    private String remarkDesc;

    @ApiModelProperty("排序")
    @Column(name = "seq", length = 5, columnDefinition = "int(5) COMMENT '排序'")
    private Integer seq;

    @ApiModelProperty("数量")
    @Column(name = "num", length = 11, columnDefinition = "int(11) COMMENT '数量'")
    private Integer num;


}
