package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 会员信息
 * @author zouhs
 * @date 2023/6/16
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MemberInfo", description = "会员信息")
@Entity
@TableName("mms_member_info")
@Table(
    name = "mms_member_info",
    indexes = {
        @Index(name = "mms_member_info_index1", columnList = "member_code",unique = true),
    })
@org.hibernate.annotations.Table(appliesTo = "mms_member_info", comment = "会员信息")
public class MemberInfo extends TenantFlagOpEntity {

    @ApiModelProperty("会员编码")
    @Column(name="member_code" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员编码'")
    private String memberCode;

    @ApiModelProperty("会员昵称")
    @Column(name="member_nick", length = 100, columnDefinition = "VARCHAR(100) COMMENT '会员昵称'")
    private String memberNick;

    @ApiModelProperty("会员手机号")
    @Column(name="member_phone", length = 20, columnDefinition = "VARCHAR(20) COMMENT '会员手机号'")
    private String memberPhone;

    @ApiModelProperty("会员姓名")
    @Column(name="member_name", length = 100, columnDefinition = "VARCHAR(100) COMMENT '会员姓名'")
    private String memberName;

    @ApiModelProperty("会员头像")
    @Column(name="member_avatar", length = 100, columnDefinition = "VARCHAR(100) COMMENT '会员头像'")
    private String memberAvatar;

    @ApiModelProperty("会员生日")
    @Column(name="member_birthday", length = 15, columnDefinition = "VARCHAR(15) COMMENT '会员生日'")
    private String memberBirthday;

    @ApiModelProperty("用户类型 1 会员 2 游客")
    @Column(name="user_type", length = 15, columnDefinition = "VARCHAR(15) COMMENT '用户类型 1 会员 2 游客'")
    private String userType;

    @ApiModelProperty("注册时间")
    @TableField(value = "member_register")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "member_register", length = -1, columnDefinition = "datetime COMMENT '注册时间'")
    private Date memberRegister;

    @ApiModelProperty("邀请人数")
    @Column(name = "invite_num", length = 11, columnDefinition = "int(11) COMMENT '邀请人数'")
    private Integer inviteNum;

    @ApiModelProperty("邀请人编码")
    @Column(name="invite_member_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '邀请人编码'")
    private String inviteMemberCode;

    @ApiModelProperty("邀请人")
    @Column(name="invite_member_name", length = 100, columnDefinition = "VARCHAR(100) COMMENT '邀请人'")
    private String inviteMemberName;

    @ApiModelProperty("邀请时间")
    @TableField(value = "invite_member_register")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "invite_member_register", length = -1, columnDefinition = "datetime COMMENT '邀请时间'")
    private Date inviteMemberRegister;

    @ApiModelProperty("部门")
    @Column(name="department", length = 64, columnDefinition = "VARCHAR(64) COMMENT '部门'")
    private String department;

    @ApiModelProperty("行业编码")
    @Column(name="industry_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '行业编码'")
    private String industryCode;

    @ApiModelProperty("行业名称")
    @Column(name="industry_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '行业名称'")
    private String industryName;

    @ApiModelProperty("激活状态,数据字典:mms_member_info_active_status,枚举:MemberActiveStatusEnum")
    @Column(name="active_status", length = 64, columnDefinition = "VARCHAR(64) COMMENT '激活状态'")
    private String activeStatus;

    @ApiModelProperty("审批人编码")
    @Column(name="approval_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '审批人编码'")
    private String approvalCode;

    @ApiModelProperty("审批人")
    @Column(name="approval_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '审批人'")
    private String approvalName;

    @ApiModelProperty("审批状态")
    @Column(name="approval_status", length = 20, columnDefinition = "VARCHAR(20) COMMENT '审批状态'")
    private String approvalStatus;

    @ApiModelProperty("审批驳回原因")
    @Column(name="approval_reject_desc", length = 225, columnDefinition = "VARCHAR(225) COMMENT '审批驳回原因'")
    private String approvalRejectDesc;

    @ApiModelProperty("审批时间")
    @TableField(value = "approval_date")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "approval_date", length = -1, columnDefinition = "datetime COMMENT '审批时间'")
    private Date approvalDate;

    @ApiModelProperty("关联品鉴顾问编码")
    @Column(name="link_tasting_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '关联品鉴编码'")
    private String linkTastingCode;

    @ApiModelProperty("关联品鉴顾问")
    @Column(name="link_tasting_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '关联品鉴顾问'")
    private String linkTastingName;

    @ApiModelProperty("关联品鉴顾问手机号")
    @Column(name="link_tasting_phone", length = 20, columnDefinition = "VARCHAR(20) COMMENT '关联品鉴顾问手机号'")
    private String linkTastingPhone;

    @ApiModelProperty("最后登录时间")
    @TableField(value = "last_login_date")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "last_login_date", length = -1, columnDefinition = "datetime COMMENT '最后登录时间'")
    private Date lastLoginDate;

}


