package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 会员档案
 * @author zouhs
 * @date 2023/6/16
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MemberInfoArchives", description = "会员档案")
@Entity
@TableName("mms_member_info_archives")
@Table(
    name = "mms_member_info_archives",
    indexes = {
        @Index(name = "mms_member_info_archives_index1", columnList = "member_code"),
        @Index(name = "mms_member_info_archives_index2", columnList = "terminal_code")
    })
@org.hibernate.annotations.Table(appliesTo = "mms_member_info_archives", comment = "会员档案")
public class MemberInfoArchives extends TenantFlagOpEntity {

  @ApiModelProperty("会员编码")
  @Column(name="member_code" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员编码'")
  private String memberCode;

  @ApiModelProperty("档案编码")
  @Column(name="terminal_code" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '档案编码'")
  private String terminalCode;

  @ApiModelProperty("档案名称")
  @Column(name="terminal_name" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '档案名称'")
  private String terminalName;

  @ApiModelProperty("档案类型")
  @Column(name="terminal_type" , length = 10, columnDefinition = "VARCHAR(10) COMMENT '档案类型'")
  private String terminalType;

  @ApiModelProperty("联系人")
  @Column(name="terminal_connect" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '联系人'")
  private String terminalConnect;

  @ApiModelProperty("手机号")
  @Column(name="terminal_phone" , length = 20, columnDefinition = "VARCHAR(20) COMMENT '手机号'")
  private String terminalPhone;

  @ApiModelProperty("开户日期")
  @TableField(value = "open_account_time")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "open_account_time", length = -1, columnDefinition = "datetime COMMENT '开户日期'")
  private Date openAccountTime;

  @ApiModelProperty("所属组织编码")
  @TableField(value = "org_code")
  @Column(name = "org_code", length = 64, columnDefinition = "varchar(64) COMMENT '所属组织编码'")
  private String orgCode;

  @ApiModelProperty("所属组织名称")
  @TableField(value = "org_name")
  @Column(name = "org_name", length = 64, columnDefinition = "varchar(64) COMMENT '组织名称'")
  private String orgName;

  @ApiModelProperty("省")
  @TableField(value = "province_code")
  @Column(name = "province_code", length = 64, columnDefinition = "varchar(64) COMMENT '省'")
  private String provinceCode;

  @ApiModelProperty("省名称")
  @TableField(value = "province_name")
  @Column(name = "province_name", length = 128, columnDefinition = "varchar(128) COMMENT '省名称'")
  private String provinceName;

  @ApiModelProperty("市")
  @TableField(value = "city_code")
  @Column(name = "city_code", length = 64, columnDefinition = "varchar(64) COMMENT '市'")
  private String cityCode;

  @ApiModelProperty("市名称")
  @TableField(value = "city_name")
  @Column(name = "city_name", length = 128, columnDefinition = "varchar(128) COMMENT '市名称'")
  private String cityName;

  @ApiModelProperty("区")
  @TableField(value = "district_code")
  @Column(name = "district_code", length = 64, columnDefinition = "varchar(64) COMMENT '区'")
  private String districtCode;

  @ApiModelProperty("区名称")
  @TableField(value = "district_name")
  @Column(name = "district_name", length = 128, columnDefinition = "varchar(128) COMMENT '区名称'")
  private String districtName;

  @ApiModelProperty("乡镇/街道")
  @TableField(value = "township_name")
  @Column(name = "township_name", length = 128, columnDefinition = "varchar(128) COMMENT '乡镇/街道'")
  private String townshipName;

  @ApiModelProperty("终端地址")
  @TableField(value = "terminal_address")
  @Column(name = "terminal_address", length = 200, columnDefinition = "varchar(200) COMMENT '终端地址'")
  private String terminalAddress;


  @ApiModelProperty("经度")
  @TableField(value = "longitude")
  @Column(name = "longitude", columnDefinition = "decimal(12,8) COMMENT '经度'")
  private BigDecimal longitude;

  @ApiModelProperty("纬度")
  @TableField(value = "latitude")
  @Column(name = "latitude", columnDefinition = "decimal(12,8) COMMENT '纬度'")
  private BigDecimal latitude;

  @ApiModelProperty("邮政编码")
  @TableField(value = "zip_code")
  @Column(name = "zip_code", length = 15, columnDefinition = "varchar(15) COMMENT '邮政编码'")
  private String zipCode;

  @ApiModelProperty("电子邮箱")
  @TableField(value = "email")
  @Column(name = "email", length = 64, columnDefinition = "varchar(64) COMMENT '电子邮箱'")
  private String email;

  /**
   * 身份证号码
   */
  @ApiModelProperty("身份证号码")
  @TableField(value = "license_person_card")
  @Column(
      name = "license_person_card",
      length = 20,
      columnDefinition = "varchar(20) COMMENT '身份证号码'")
  private String licensePersonCard;

  /**
   * 营业执照人名称
   */
  @ApiModelProperty("营业执照人名称")
  @TableField(value = "license_person_name")
  @Column(
      name = "license_person_name",
      length = 255,
      columnDefinition = "varchar(255) COMMENT '营业执照人名称'")
  private String licensePersonName;

  /**
   * 营业执照注册号
   */
  @ApiModelProperty("营业执照注册号")
  @TableField(value = "license_register_number")
  @Column(
      name = "license_register_number",
      length = 255,
      columnDefinition = "varchar(255) COMMENT '营业执照注册号'")
  private String licenseRegisterNumber;

  /**
   * 营业执照企业名称
   */
  @ApiModelProperty("营业执照企业名称")
  @TableField(value = "license_firm_name")
  @Column(
      name = "license_firm_name",
      length = 255,
      columnDefinition = "varchar(255) COMMENT '营业执照企业名称'")
  private String licenseFirmName;

  /**
   * 店招照片
   */
  @ApiModelProperty("店招照片")
  @TableField(value = "shop_image_path")
  @Column(name = "shop_image_path", length = 255, columnDefinition = "varchar(255) COMMENT '店招照片'")
  private String shopImagePath;

  /**
   * 营业执照照片
   */
  @ApiModelProperty("营业执照照片")
  @TableField(value = "license_image_path")
  @Column(
      name = "license_image_path",
      length = 255,
      columnDefinition = "varchar(255) COMMENT '营业执照照片'")
  private String licenseImagePath;
}
