package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 会员资产
 * @author zouhs
 * @date 2023/6/19
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MemberInfoAssets", description = "会员资产")
@Entity
@TableName("mms_member_info_assets")
@Table(
    name = "mms_member_info_assets",
    indexes = {
        @Index(name = "mms_member_info_assets_index1", columnList = "member_code"),
    })
@org.hibernate.annotations.Table(appliesTo = "mms_member_info_assets", comment = "会员资产")
public class MemberInfoAssets extends TenantFlagOpEntity {

  @ApiModelProperty("会员编码")
  @Column(name="member_code" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员编码'")
  private String memberCode;

  @ApiModelProperty("累计积分")
  @Column(name = "total_integral", length = 11, columnDefinition = "int(11) COMMENT '累计积分'")
  private Integer totalIntegral;

  @ApiModelProperty("当前积分")
  @Column(name = "current_integral", length = 11, columnDefinition = "int(11) COMMENT '当前积分'")
  private Integer currentIntegral;

  @ApiModelProperty("累计成长值")
  @Column(name = "total_grow", length = 11, columnDefinition = "int(11) COMMENT '累计成长值'")
  private Integer totalGrow;

  @ApiModelProperty("当前成长值")
  @Column(name = "current_grow", length = 11, columnDefinition = "int(11) COMMENT '当前成长值'")
  private Integer currentGrow;

  @ApiModelProperty("等级编码")
  @Column(name = "level_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '等级编码'")
  private String levelCode;

  @ApiModelProperty("等级名称")
  @Column(name = "level_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '等级名称'")
  private String levelName;

  @ApiModelProperty("会员权益数")
  @Column(name = "benefits_num", length = 11, columnDefinition = "int(11) COMMENT '会员权益数'")
  private Integer benefitsNum;

  @ApiModelProperty("待兑权益数")
  @Column(name = "stay_benefits_num", length = 11, columnDefinition = "int(11) COMMENT '待兑权益数'")
  private Integer stayBenefitsNum;

  @ApiModelProperty("品鉴顾问权益")
  @Column(name = "tasting_benefits_num", length = 11, columnDefinition = "int(11) COMMENT '品鉴顾问权益'")
  private Integer tastingBenefitsNum;

  @ApiModelProperty("品鉴顾问待兑权益")
  @Column(name = "stay_tasting_benefits_num", length = 11, columnDefinition = "int(11) COMMENT '品鉴顾问待兑权益'")
  private Integer stayTastingBenefitsNum;

  @ApiModelProperty("大转盘奖品")
  @Column(name = "big_wheel_prizes", length = 11, columnDefinition = "int(11) COMMENT '大转盘奖品'")
  private Integer bigWheelPrizes;

  @ApiModelProperty("待兑大转盘奖品")
  @Column(name = "stay_big_wheel_prizes", length = 11, columnDefinition = "int(11) COMMENT '累计成长值'")
  private Integer stayBigWheelPrizes;

}
