package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 会员权益关联表
 * @author zouhs
 * @date 2023/6/20
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MemberInfoBenefits", description = "会员权益关联表")
@Entity
@TableName("mms_member_info_benefits")
@Table(
    name = "mms_member_info_benefits",
    indexes = {
        @Index(name = "mms_member_info_benefits_index1", columnList = "member_code"),
        @Index(name = "mms_member_info_benefits_index2", columnList = "benefits_code"),
        @Index(name = "mms_member_info_benefits_index3", columnList = "order_code")
    })
@org.hibernate.annotations.Table(appliesTo = "mms_member_info_benefits", comment = "会员权益关联表")
public class MemberInfoBenefits extends TenantFlagOpEntity {

  @ApiModelProperty("会员编码")
  @Column(name="member_code" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员编码'")
  private String memberCode;

  @ApiModelProperty("权益编码")
  @Column(name = "benefits_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '权益编码'")
  private String benefitsCode;

  @ApiModelProperty("权益名称")
  @Column(name = "benefits_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '权益名称'")
  private String benefitsName;

  @ApiModelProperty("权益类型,数据字典:mms_benefits_type,枚举:BenefitsTypeEnum")
  @Column(name = "benefits_type", length = 30, columnDefinition = "VARCHAR(30) COMMENT '权益类型'")
  private String benefitsType;

  @ApiModelProperty("兑换状态,数据字典:mms_member_info_benefits_exchange_status,枚举:MemberInfoBenefitsStatusEnum")
  @Column(name = "exchange_status", length = 30, columnDefinition = "VARCHAR(30) COMMENT '兑换状态'")
  private String exchangeStatus;

  @ApiModelProperty("会员权益类型,数据字典:mms_member_info_benefits_member_benefits_type,枚举:MemberInfoMemberBenefitsTypeEnum")
  @Column(name = "member_benefits_type", length = 30, columnDefinition = "VARCHAR(30) COMMENT '会员权益类型'")
  private String memberBenefitsType;

  @ApiModelProperty("转赠人编码")
  @Column(name = "gift_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '转赠人编码'")
  private String giftCode;

  @ApiModelProperty("转赠人姓名")
  @Column(name = "gift_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '转赠人姓名'")
  private String giftName;

  @ApiModelProperty("转赠人手机号")
  @Column(name = "gift_phone", length = 64, columnDefinition = "VARCHAR(64) COMMENT '转赠人手机号'")
  private String giftPhone;

  @ApiModelProperty("兑换时间")
  @TableField(value = "exchange_time")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "exchange_time", length = -1, columnDefinition = "date COMMENT '兑换时间'")
  private Date exchangeTime;

  @ApiModelProperty("关联订单号")
  @Column(name = "order_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '关联订单号'")
  private String orderCode;

  @ApiModelProperty("单位,数据字典:mms_benefits_unit,枚举:BenefitsUnitEnum")
  @Column(name = "unit", length = 10, columnDefinition = "VARCHAR(10) COMMENT '单位'")
  private String unit;

  @ApiModelProperty("产品图片")
  @Column(name = "product_image", length = 100, columnDefinition = "VARCHAR(100) COMMENT '产品图片'")
  private String productImage;

  @ApiModelProperty("产品详情")
  @Column(name = "product_desc", length = 0, columnDefinition = "text COMMENT '产品详情'")
  private String productDesc;

  @ApiModelProperty("兑换有效期(月)")
  @Column(name = "exchange_valid_period", length = 5, columnDefinition = "int(5) COMMENT '兑换有效期(月)'")
  private Integer exchangeValidPeriod;

  @ApiModelProperty("使用有效期(天)")
  @Column(name = "use_valid_period", length = 5, columnDefinition = "int(5) COMMENT '使用有效期(天)'")
  private Integer useValidPeriod;

  @ApiModelProperty("数量")
  @Column(name = "num", length = 11, columnDefinition = "int(11) COMMENT '数量'")
  private Integer num;

  @ApiModelProperty("领取过期时间")
  @JsonFormat(
      locale = "zh",
      timezone = "GMT+8",
      pattern = "yyyy-MM-dd HH:mm:ss"
  )
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "exchange_expire_time", length = 20, columnDefinition = "datetime COMMENT '领取过期时间'")
  private Date exchangeExpireTime;

  @ApiModelProperty("获得权益时间")
  @JsonFormat(
      locale = "zh",
      timezone = "GMT+8",
      pattern = "yyyy-MM-dd HH:mm:ss"
  )
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "obtain_benefits_time", length = 20, columnDefinition = "datetime COMMENT '获取权限时间'")
  private Date obtainBenefitsTime;

  @ApiModelProperty("等级关联权益")
  @Column(name = "level_manage_benefits_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '权益编码'")
  private String levelManageBenefitsCode;

  @ApiModelProperty("关联组织编码")
  @Column(name = "org_code", length = 45, columnDefinition = "VARCHAR(45) COMMENT '关联组织编码'")
  private String orgCode;

  @ApiModelProperty("关联组织名称")
  @Column(name = "org_name", length = 45, columnDefinition = "VARCHAR(45) COMMENT '关联组织名称'")
  private String orgName;
}
